// ips7demoDlg.h : header file
//

#if !defined(AFX_IPS7DEMODLG_H__00660AC6_A4E2_11D8_8264_00409530DEE5__INCLUDED_)
#define AFX_IPS7DEMODLG_H__00660AC6_A4E2_11D8_8264_00409530DEE5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CIPS7demoDlg dialog
#include "IPS7lnk.h"
#include "afxwin.h"


class CIPS7demoDlg : public CDialog
{
// Construction


public:
  int ReadDBLen ();
  bool GetTSAPFromEdit (CString &Str, BYTE *pTSAP);
  void SetOpenState (bool bState);

  void InitRq (IPS7_RQ_MULTI *pRq, long DataArea, long DataType, long PcDataArea, long DBNr,  long Start, long StartBit, long Cnt, void *pData);
  void AddItemsToList (int DataArea, int DBNr, int Line, int StartAt, int StartBit, int Cnt, int PCDataType, int PLCDataType,  void *pD, bool bShowHex = true, int Result = 0);
  void SetListItemData (int Line, int Item, int PCDataType, int PLCDataType, void *pData, bool bShowHex, int Result);
  void ShowErrInList (int Line);
  const char *MakeAdrName (int DataArea, int DBNr, int PLCDataType);
 void ShowConnectStatus ();
	BOOL m_bConnected;
	HANDLE m_hLogo;
	CString m_strAdrName;
	HCURSOR m_hNormalCursor;
  HCURSOR m_hWaitCursor;
	void SetNormalCursor ();
	void SetWaitCursor ();
	double m_DoubleBuf[2048];
	DWORD m_DWordBuf[2048];
	//WORD m_WordBuf[2048];
  WORD m_WordBuf[16000];
	BYTE m_ByteBuf[2048];
	char m_strBuf[2048];
  char m_strStr[256][256];
  INT64 m_Int64Buf[2048];
	void ShowErr ();
  CString GetStatusText ();
  long m_lRef;
  long m_lErr;
	BYTE m_DataArea;
  BOOL m_bUseOP;
  bool m_bOpenState;
	CIPS7demoDlg(CWnd* pParent = NULL);    // standard constructor

// Dialog Data
	//{{AFX_DATA(CIPS7demoDlg)
	enum { IDD = IDD_IPS7DEMO_DIALOG };
	CButton	m_ctrlRdMulti;
	CEdit	m_ctrlIPStatus;
	CButton	m_ctrlUsePG;
	CButton	m_ctrlUseOP;
	CButton	m_ctrlRdReal;
	CButton	m_ctrlRdDWord;
	CEdit	m_ctrlSlotNr;
	CEdit	m_ctrlRackNr;
	CStatic	m_ctrlLogo;
	CEdit	m_ctrlIPAddress;
	CEdit	m_ctrlDBNo;
	CEdit	m_ctrlStatus;
	CButton	m_ctrlRdWord;
	CButton	m_ctrlRdByte;
	CButton	m_ctrlOpen;
	CComboBox	m_ctrlDataArea;
	CListCtrl	m_ctrlDataList;
	CButton	m_ctrlClose;
	UINT	m_uCount;
	UINT	m_uDBNo;
	CString	m_strIPAddr;
	UINT	m_uStartAt;
	UINT	m_RackNr;
	UINT	m_SlotNr;
	int		m_PLCType;
	CString	m_strIPStatus;
    BYTE    m_LocalTSAP[2];
    BYTE    m_RemoteTSAP[2];
    bool    m_bUseTSAP;

	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CIPS7demoDlg)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void CalcWindowRect(LPRECT lpClientRect, UINT nAdjustType = adjustBorder);
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CIPS7demoDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnOpen();
	afx_msg void OnClose();
	afx_msg void OnRdByte();
	afx_msg void OnRdWord();
	afx_msg void OnSelChangeDataArea();
	afx_msg void OnRdDWord();
	afx_msg void OnRdReal();
	afx_msg void OnUseOP();
	afx_msg void OnUsePG();
	//afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnRdMulti();

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnCbnSelchangePlctype();
	CComboBox m_ctrlPlcType;
	afx_msg void OnBnClickedPLCInfo();
	CButton m_ctrlGetPlcTime;
	afx_msg void OnBnClickedRdstr();
	CButton m_ctrlRdStr;
  afx_msg void OnBnClickedRdLInt();
  CButton m_ctrlRdLInt;
  CString m_strLocalTSAP;
  CString m_strRemoteTSAP;
  CEdit m_ctrlLocalTSAP;
  CEdit m_ctrlRemoteTSAP;
  CString m_DBLen;
  CEdit m_ctrlDBLen;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IPS7DEMODLG_H__00660AC6_A4E2_11D8_8264_00409530DEE5__INCLUDED_)
