(* Author : 
     Dipl.-Ing. A. Traeger
     Traeger Industriesoftware
'    Mitglied im TPA e.V.
'    Vertrieb durch:
'    Process Informatik GmbH
'    Im Gewerbegebiet 1
'    73116 Waeschenbeuren
'    Tel. 07172/926660
'    Fax  07172/9266630
'           
*)
{ -- Versiopn 1.77 --}
{ V 1.52 PChar in PAnsiChar gendert, wg. Delphi 9.0 da sind char widechar ( 2 byte) wie bentigen 2 Byte, vorher war pChar }
unit IPS7LNK;

interface
CONST
  IPS7_E_NOERR    =   0;  // Aktion wurde erfolgreich ausgeführt.(0)
  IPS7_E_NODATA   =   2;  // Der angeforderte Datenbereich in der SPS ist nicht vorhanden.(z.B. DB gibt es nicht).
  IPS7_E_TIMEOUT  =  -1;  // Es ist ein Zeitüberlauf bei der TCP/IP-Kommunikation aufgetreten. (-1)

  IPS7_E_NORESOURCE = -2;  // Maximale Anzahl der Verbindungen erreicht
  IPS7_E_REFNOTOPEN = -3;  // Kann bei Close auftreten. Mit der angegebenen Referenz wurde kein Open ausgefhrt.
  IPS7_E_GENERAL    =  -5;  // genereller Fehler aufgetreten
  IPS7_E_CPU_NOTFOUND = -6;  // Die mit Rack- und Slotnummer angegebene Ziel-CPU wurde nicht gefunden.
  IPS7_E_SOCKERR      = -7;  // Es ist ein Socketfehler aufgetreten.
  IPS7_E_MEMERR       = -8;  // Angeforderter Speicher im PC ist nicht verfügbar
  IPS7_E_RANGEERR     = -9;  // Bereichsüberschreitung. z.B wurde versucht einen Timer > 9990000 ms zu setzen.


  IPS7_E_ACCESSMODE  = -10;  // Eine unzulässige Nummer im AccessMode bei OpenEx wurde angegeben.
  IPS7_E_NOTSUPPORTED = -11;  // Der gewnschte Datentyp ist fr den angegeben Speicherbereich der SPS nicht erlaubt (z.B. Byte zugriff bei Zhler). (-11)
  IPS7_E_PC_BUFSIZE   = -20;  // Der angegebene Speicher des PC ist zu klein (z.B. Array zu klein). (-20)
  IPS7_E_ALREADY_OPENED = -21; // fr diese Instanz der Klasse wurde schon einmal ein Open ausgefhrt. Evtl. Close aufrufen. (-21)


  IPS7_PC_E_S7_DATATYPE_BAD_REL = -31; // PC und S7-Daten typ stehen falscher Relation z.B. PC = BYTE SPS = Wort und es soll gelesen werden
  IPS7_E_BADDATACOUNT = -32; // S7 liefert falsche Anzahl an Daten
  IPS7_E_SUPPORT_NO_BITARRAY = -33; // Zugriff auf mehrere Bits hintereinander nicht untersttzt

// 1.40
   IPS7_E_BAD_RQBLOCK = -34; // der gewnschte Requestblock konnte nicht zugeordnet werden

// 1.78
  IPS7_E_BLOCK_NOT_EXIST = -35;               // DB doesn't exist
  IPS7_E_FUNCTION_NOT_SUPPORTED_BY_PLC = -36; // function not supported by PLC


  IPS7_E_NOT_YET_PROCESSED = -88; // der Auftrag wurde nich bearbeitet, wir beim Automatischen Multiread verwendet


  IPS7_E_BADREF    =   -99;  //	Die Referenznummer ist ungltig
  IPS7_E_DEMOEND   =  4660;  // Demozeit ist abgelaufen

{ -- Version 1.35 --}
CONST
  IPS7_BIT = 0;
  IPS7_BYTE = 1;
  IPS7_WORD = 2; { 16 Unsigned }
  IPS7_INT = 3;  { 16 Bit signed }
  IPS7_DWORD = 4;
  IPS7_DINT = 5; { 32 Bit signed}
  IPS7_REAL = 6;
  IPS7_TIMER = 7;
  IPS7_COUNTER = 8;
  IPS7_BADTYPE = 9;

  PC_BYTE = 0;
  PC_WORD16 = 1;
  PC_INT16 = 2;
  PC_WORD32 = 3;
  PC_INT32 = 4;
  PC_FLOAT = 5;
  PC_DOUBLE = 6;

TYPE PWORD =  ^WORD;
TYPE PBYTE =  ^BYTE;
TYPE PDWORD =  ^Longword;
TYPE PDOUBLE = ^Double;

{ -- Versiopn 1.35 --}

TYPE IPS7_RQ_MULTI = packed record
  DataArea : LongInt;
  DataType : LongInt;
  DBNr : LongInt;
  Cnt : LongInt;
  Start : LongInt;
  StartBit : LongInt;
  PcDataType : LongInt;
  Result : LongInt;
  UserData_0 : LongInt;
  UserData_1 : LongInt;
  Data : Pointer;
  pUserData : Pointer;
end;

TYPE PIPS7_RQ_MULTI = ^IPS7_RQ_MULTI;
PWideChar                       
FUNCTION
IPS7Open (IPAdr : PAnsiChar; Rack : LongWord; Slot : LongWord; RxTimeout : LongWord; TxTimeout : LongWord ; ConnectTimeout : LongWord) : LongInt; stdcall; external 'IPS7LNK.DLL';      

FUNCTION
IPS7OpenPG (IPAdr : PAnsiChar; Rack : LongWord; Slot : LongWord; RxTimeout : LongWord; TxTimeout : LongWord ; ConnectTimeout : LongWord) : LongInt; stdcall; external 'IPS7LNK.DLL';      

FUNCTION
IPS7OpenEx (IPAdr : PAnsiChar; Rack : LongWord; Slot : LongWord; SubNetId : LongWord; DstMPIAdr : LongWord;	AccessMode : LongWord;
            RxTimeout : LongWord; TxTimeout : LongWord ; ConnectTimeout : LongWord) : LongInt; stdcall; external 'IPS7LNK.DLL';      

FUNCTION
IPS7OpenExWithTSAP (IPAdr : PAnsiChar; Rack : LongWord; Slot : LongWord; SubNetId : LongWord; DstMPIAdr : LongWord;	AccessMode : LongWord;
            RxTimeout : LongWord; TxTimeout : LongWord ; ConnectTimeout : LongWord; LocalTSAP: PBYTE; RemoteTSAP: PBYTE) : LongInt; stdcall; external 'IPS7LNK.DLL';      



FUNCTION
IPS7OpenS7200 (IPAdr : PAnsiChar; Rack : LongWord; Slot : LongWord; RxTimeout : LongWord; TxTimeout : LongWord ; ConnectTimeout : LongWord) : LongInt; stdcall; external 'IPS7LNK.DLL';


FUNCTION
IPS7Close (Ref : LongInt) : LongInt; stdcall; external 'IPS7LNK.DLL';      

FUNCTION
IPS7RdW (Ref : LongInt; Typ : Longword; DBNr : Longword; AbWort : Longword; WortAnz : Longword;  Buffer : PWORD)  : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7RdB (Ref : LongInt; Typ : Longword;  DBNr: Longword;
          Ab : Longword;  Anz : Longword; Buffer: PBYTE) : LongInt; stdcall; external 'IPS7LNK.DLL';


FUNCTION
IPS7WrW (Ref : LongInt; Typ : Longword; DBNr : Longword; AbWort : Longword; WortAnz : Longword; Buffer : PWORD)  : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7WrB (Ref : LongInt; Typ : Longword;  DBNr: Longword;
         Ab : Longword;  Anz : Longword; Buffer: PBYTE) : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7GetSockErr (Ref : LongInt) : LongInt; stdcall; external 'IPS7LNK.DLL';


FUNCTION
IPS7RdBit (Ref : LongInt; Typ : Longword;  DBNr: Longword;
           ByteNr : Longword;  BitNr : Longword; Buffer: PBYTE) : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7SetBit (Ref : LongInt; Typ : Longword;  DBNr: Longword;
            ByteNr : Longword;  BitNr : Longword) : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7ResetBit (Ref : LongInt; Typ : Longword;  DBNr: Longword;
            ByteNr : Longword;  BitNr : Longword) : LongInt; stdcall; external 'IPS7LNK.DLL';
FUNCTION
IPS7RdDW (Ref : LongInt; Typ : Longword; DBNr : Longword; AbWort : Longword; WortAnz : Longword;  Buffer : PDWORD)  : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7WrDW (Ref : LongInt; Typ : Longword; DBNr : Longword; AbWort : Longword; WortAnz : Longword;  Buffer : PDWORD)  : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7RdReal (Ref : LongInt; Typ : Longword; DBNr : Longword; AbWort : Longword; WortAnz : Longword;  Buffer : PDOUBLE)  : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7WrReal (Ref : LongInt; Typ : Longword; DBNr : Longword; AbWort : Longword; WortAnz : Longword;  Buffer : PDOUBLE)  : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7RdPlcW (Ref : LongInt; Typ : Longword; DBNr : Longword; AbWort : Longword; WortAnz : Longword;  Buffer : PDWORD)  : LongInt; stdcall; external 'IPS7LNK.DLL';

FUNCTION
IPS7WrPlcW (Ref : LongInt; Typ : Longword; DBNr : Longword; AbWort : Longword; WortAnz : Longword;  Buffer : PDWORD)  : LongInt; stdcall; external 'IPS7LNK.DLL';


{ Version 1.35 }
FUNCTION
IPS7GetConnectStatus ( Ref : LongInt) : LongInt; stdcall; external 'IPS7LNK.DLL';

{ -- Versiopn 1.35 --}
FUNCTION
IPS7SetKeepAlive (Ref : LongInt; AliveInterval : Longword; AliveTime : Longword) : LongInt; stdcall; external 'IPS7LNK.DLL';

{ -- Versiopn 1.35 --}
FUNCTION
IPS7Connect (Ref : LongInt) : LongInt; stdcall; external 'IPS7LNK.DLL';

{ -- Versiopn 1.35 --}
FUNCTION
IPS7RdMulti (Ref : LongInt; pRqList : PIPS7_RQ_MULTI; Cnt : Longword)  : LongInt; stdcall; external 'IPS7LNK.DLL';

{ -- Versiopn 1.35 --}
FUNCTION
IPS7RdMultiSimplex (Ref : LongInt;  pRqList : PIPS7_RQ_MULTI; Cnt : Longword) : LongInt; stdcall; external 'IPS7LNK.DLL';

{ -- Versiopn 1.39 --}
FUNCTION
IPS7RdMultiCalcPacketCnt (Ref : LongInt;  pRqList : PIPS7_RQ_MULTI; Cnt : Longword) : LongInt; stdcall; external 'IPS7LNK.DLL';

{ -- Versiopn 1.71.92 --}
FUNCTION
IPS7SetTCPPort (Ref : LongInt;  Port : Longword) : LongInt; stdcall; external 'IPS7LNK.DLL';

{ -- Versiopn 1.78.00 --}
FUNCTION
IPS7GetDBLen (Ref : LongInt;  DBNr : Longword) : LongInt; stdcall; external 'IPS7LNK.DLL';


implementation

begin
end.
