/* Author : 
     Dipl.-Ing. A. Traeger
     Traeger Industriesoftware
     Mitglied im TPA e.V.
     Vertrieb durch:
     Process Informatik GmbH
     Im Gewerbegebiet 1
     73116 Waeschenbeuren
     Tel. 07172/926660
     Fax  07172/9266630
*/           
/* IPS7LNK.H
   Version 1.77
*/

#ifndef _IPS7LNK_H_45632
#define _IPS7LNK_H_45632

#ifdef __cplusplus
extern "C" {
#endif


//#if !defined (WINVER ) && !defined (WINCE) // for Linux or other embedded systems
#if !defined (WINVER ) // for Linux or other embedded systems
  #ifndef WINTYPES_DEFINED
    #define WINTYPES_DEFINED
	  #define WINAPI

    #ifdef __ICCARM__ // IAR 1.52
      #include <types.h>
	    typedef unsigned char *LPBYTE;
	    typedef unsigned char *PBYTE;
	    typedef char          *PSTR;
	    typedef char          *LPSTR;
	    typedef const char    *LPCTSTR;
	    typedef const char    *LPCSTR;
	    typedef const char    *PCSTR;
	    typedef U16           UINT16;
	    typedef U16           *LPWORD;
	    typedef U16           *PWORD;
	    typedef S16           INT16;
	    typedef S16           BOOL16;
	    typedef S16           *LPINT;
	    typedef U32           UINT32;
	    typedef U32           *PDWORD;
	    typedef U32           *LPDWORD;
	    typedef S32           INT32;
	    typedef void          *PVOID;
      typedef U64           UINT64;
      typedef S64           INT64;
      #define __IPS7_PACKED__  __packed
    #else
	    #include <sys/types.h>
	    typedef unsigned char BYTE;
	    typedef unsigned char *LPBYTE;
	    typedef unsigned char *PBYTE;
	    typedef char *PSTR;
	    typedef char *LPSTR;
	    typedef const char *LPCTSTR;
	    typedef const char *LPCSTR;
	    typedef const char *PCSTR;
	    typedef u_int16_t  WORD;
	    typedef u_int16_t  *LPWORD;
	    typedef u_int16_t  *PWORD;
	    typedef int16_t INT;
	    typedef int16_t  *LPINT;
	    typedef u_int32_t  DWORD;
	    typedef u_int32_t *PDWORD;
	    typedef u_int32_t *LPDWORD;
	    typedef void  VOID;
	    typedef void *PVOID;
	    typedef void *LPVOID;
	    typedef int BOOL;
	    typedef int16_t BOOL16;
      typedef u_int64_t UINT64; // 1.73
      typedef int64_t INT64; // 1.73

	    #define __IPS7_PACKED__  __attribute__((packed))
    #endif

  #endif

/*
  nur fr LINUX und Embeddedsysteme, gibt reservierten Speicher frei uns schliesst Sockets!
*/

void
IPS7CloseAll (void);


#else
////#ifdef WINCE
////  typedef signed __int64      INT64, *PINT64;
////  typedef unsigned __int64    UINT64, *PUINT64;
////#endif

  #define __IPS7_PACKED__
  #pragma  pack (push, 1)
#endif // __linux__

enum
{
  IPS7_BIT = 0,
  IPS7_BYTE,
  IPS7_WORD, // 16 Unsigned
  IPS7_INT,  // 16 Bit signed
  IPS7_DWORD,
  IPS7_DINT, // 32 Bit signed
  IPS7_REAL,
  IPS7_TIMER,
  IPS7_COUNTER,
	IPS7_STRING, // 1.61

  IPS7_LINT, // 1.73.00 64 Bit signed
  IPS7_ULINT, // 1.73.00 64 Bit unsigned 

  IPS7_BADTYPE 
};

enum
{
  PC_BYTE,
  PC_WORD16,
  PC_INT16,
  PC_WORD32,
  PC_INT32,
  PC_FLOAT,
  PC_DOUBLE,
	PC_STRING, // 1.61

  PC_WORD64, // 1.73
  PC_INT64,  // 1.73

};

typedef struct 
{
  long DataArea;
  long DataType;
  long DBNr;
  long Cnt;
  long Start;
  long StartBit;
  long PcDataType;
  long Result;
  long UserData_0;
  long UserData_1;
  void *Data; 
  void *pUserData;
}  __IPS7_PACKED__ IPS7_RQ_MULTI;


typedef struct 
{
  IPS7_RQ_MULTI Rq;
	long RefNr; // wird vom Treiber gesetzt und verwendet
	long Index; // wird vom Treiber gesetzt und verwendet
}  __IPS7_PACKED__ IPS7_RQ_MULTI_BUFFERED;

typedef struct // 1.68
{
  BYTE Year;
  BYTE Month;
  BYTE Day;
  BYTE Hour;
  BYTE Minute;
  BYTE Second;
  BYTE Centisecond;
  BYTE Millisecond;
} S7_TIMESTAMP;



typedef struct  // 1.68
{
  WORD EventId;
  BYTE Priority;
  BYTE OBNr;
  BYTE Reserved[2];
  BYTE Info1[2];
  BYTE Info2[4];
  S7_TIMESTAMP Time;
  const char *Text;
} S7_EVENTENTRY;


// Errorlist

#define IPS7_E_NOERR        0  // Aktion wurde erfolgreich ausgeführt.(0)
#define IPS7_E_NODATA       2  // Der angeforderte Datenbereich in der SPS ist nicht vorhanden.(z.B. DB gibt es nicht). 
#define IPS7_E_TIMEOUT     -1  // Es ist ein Zeitüberlauf bei der TCP/IP-Kommunikation aufgetreten. (-1)

#define IPS7_E_NORESOURCE     -2  // Maximale Anzahl der Verbindungen erreicht
#define IPS7_E_REFNOTOPEN     -3  // Kann bei Close auftreten. Mit der angegebenen Referenz wurde kein Open ausgefhrt. 
#define IPS7_E_GENERAL        -5  // genereller Fehler aufgetreten
#define IPS7_E_CPU_NOTFOUND   -6  // Die mit Rack- und Slotnummer angegebene Ziel-CPU wurde nicht gefunden.
#define IPS7_E_SOCKERR        -7  // Es ist ein Socketfehler aufgetreten.
#define IPS7_E_MEMERR         -8  // Angeforderter Speicher im PC ist nicht verfügbar
#define IPS7_E_RANGEERR       -9  // Bereichsüberschreitung. z.B wurde versucht einen Timer > 9990000 ms zu setzen.

// for .net
#define IPS7_E_ACCESSMODE    -10  // Eine unzulässige Nummer im AccessMode bei OpenEx wurde angegeben. 
#define IPS7_E_NOTSUPPORTED  -11  // Der gewnschte Datentyp ist fr den angegeben Speicherbereich der SPS nicht erlaubt (z.B. Byte zugriff bei Zhler). (-11)
#define IPS7_E_PC_BUFSIZE    -20  // Der angegebene Speicher des PC ist zu klein (z.B. Array zu klein). (-20)
#define IPS7_E_ALREADY_OPENED -21 // fr diese Instanz der Klasse wurde schon einmal ein Open ausgefhrt. Evtl. Close aufrufen. (-21)

// ab 1.33
#define IPS7_PC_E_S7_DATATYPE_BAD_REL  -31 // PC und S7-Daten typ stehen falscher Relation z.B. PC = BYTE SPS = Wort und es soll gelesen werden
#define IPS7_E_BADDATACOUNT     -32 // S7 liefert falsche Anzahl an Daten
#define IPS7_E_SUPPORT_NO_BITARRAY -33 // Zugriff auf mehrere Bits hintereinander nicht untersttzt
// 1.40
#define IPS7_E_BAD_RQBLOCK -34 // der gewnschte Requestblock konnte nicht zugeordnet werden

// 1.78
#define IPS7_E_BLOCK_NOT_EXIST -35  // DB doesn't exist
#define IPS7_E_FUNCTION_NOT_SUPPORTED_BY_PLC -36 // function not supported by PLC



#define IPS7_E_NOT_YET_PROCESSED   -88 // der Auftrag wurde noch nicht bearbeitet, wir beim Automatischen Multiread verwendet

// for all
#define IPS7_E_BADREF         -99 // 99	Die Referenznummer ist ungltig
#define IPS7_E_DEMOEND       4660	  // Demozeit ist abgelaufen


long WINAPI // S7-200 1.21
IPS7OpenS7200 (LPCTSTR IPAdr, DWORD Rack, DWORD Slot, DWORD RxTimeout, DWORD TxTimeout, DWORD ConnectTimeout);

long WINAPI
IPS7Open (LPCTSTR IPAdr, DWORD Rack, DWORD Slot, DWORD RxTimeout, DWORD TxTimeout, DWORD ConnectTimeout);      

long WINAPI
IPS7OpenPG (LPCTSTR IPAdr, DWORD Rack, DWORD Slot, DWORD RxTimeout, DWORD TxTimeout, DWORD ConnectTimeout);  // 1.17
    
extern long WINAPI
IPS7Close (long Ref);

extern long WINAPI
IPS7RdW (long Ref, DWORD Typ, DWORD DBNr, DWORD AbWort, DWORD WortAnz, LPWORD Buffer) ;

extern long WINAPI
IPS7WrW (long Ref, DWORD Typ, DWORD DBNr, DWORD Ab, DWORD Anz, LPWORD Buffer);

extern long WINAPI // 1.17
IPS7RdPlcW (long Ref, DWORD Typ, DWORD DBNr, DWORD AbWort, DWORD WortAnz, LPWORD Buffer) ;

extern long WINAPI // 1.17
IPS7WrPlcW (long Ref, DWORD Typ, DWORD DBNr, DWORD Ab, DWORD Anz, LPWORD Buffer);

extern long WINAPI
IPS7WrB (long Ref, DWORD Typ, DWORD DBNr, DWORD Ab, DWORD Anz, LPBYTE Buffer);

extern long WINAPI
IPS7RdB (long Ref, DWORD Typ,  DWORD DBNr, DWORD Ab, DWORD Anz, LPBYTE Buffer);

extern long WINAPI
IPS7GetSockErr (long Ref);

long WINAPI
IPS7RdBit (long Ref, DWORD Typ, DWORD DBNr, DWORD Byte, DWORD Bit, LPBYTE Buffer);

long WINAPI
IPS7SetBit (long Ref, DWORD Typ, DWORD DBNr, DWORD Byte, DWORD Bit);

long WINAPI
IPS7ResetBit (long Ref, DWORD Typ, DWORD DBNr, DWORD Byte, DWORD Bit); 

long WINAPI
IPS7RdReal (long Ref, DWORD Typ, DWORD DBNr, DWORD Ab, DWORD Anz, double *Buffer);

long WINAPI
IPS7WrReal (long Ref, DWORD Typ, DWORD DBNr, DWORD Ab, DWORD Anz, double *Buffer);

long WINAPI
IPS7RdDW (long Ref, DWORD Typ, DWORD DBNr, DWORD Ab, DWORD Anz, LPDWORD Buffer);

long WINAPI
IPS7WrDW (long Ref, DWORD Typ, DWORD DBNr, DWORD Ab, DWORD Anz, LPDWORD Buffer);

long WINAPI
IPS7OpenEx (LPCTSTR IPAdr, DWORD Rack, DWORD Slot, DWORD SubNetId, DWORD DstMPIAdr, DWORD AccessMode, DWORD RxTimeout, DWORD TxTimeout, DWORD ConnectTimeout);      // 1.23

long WINAPI
IPS7GetConnectStatus (long Ref); // 1.33

long WINAPI
IPS7SetKeepAlive (long Ref, DWORD AliveInterval, DWORD AliveTime); // 1.33

long WINAPI
IPS7Connect (long Ref); // 1.33

long WINAPI
IPS7RdMulti (long Ref, IPS7_RQ_MULTI *pRqList, DWORD Cnt);

void WINAPI 
IPS7CloseAll (void);

long WINAPI
IPS7RdMultiSimplex (long Ref, IPS7_RQ_MULTI *pRqList, DWORD Cnt); // 1.36


long WINAPI
IPS7RdMultiBuffered (long Ref, IPS7_RQ_MULTI_BUFFERED *pRqList, DWORD Cnt); // 1.40

long WINAPI
IPS7RdMultiGetData (long Ref, IPS7_RQ_MULTI_BUFFERED *pRq, void *pData); // 1.40

long WINAPI
IPS7GetPLCTime (long Ref, long *pYear, long *pMonth, long *pDay, long *pHour, long *pMin, long *pSec, long *pMs); // 1.54

long WINAPI
IPS7SetPLCTime (long Ref, long Year, long Month, long Day, long Hour, long Min, long Sec, long Ms); // 1.54

long WINAPI
IPS7GetPLCName(long Ref, char *Str); // 1.55

long WINAPI
IPS7GetModuleName(long Ref, char *Str); // 1.55

long WINAPI
IPS7GetPlantIdName(long Ref, char *Str); // 1.55

long WINAPI
IPS7GetCopyrightEntry(long Ref, char *Str); // 1.55

long WINAPI
IPS7GetModuleSNr(long Ref, char *Str); // 1.55

long WINAPI
IPS7GetModuleTypeName(long Ref, char *Str); // 1.55

long WINAPI
IPS7GetMMCSNr(long Ref, char *Str); // 1.55

long WINAPI
IPS7GetOEMId(long Ref, char *Str); // 1.55

long WINAPI
IPS7GetLocationDesignation (long Ref, char *Str); // 1.55


long WINAPI
IPS7WrStr (long Ref, DWORD Typ, DWORD DBNr, DWORD Ab, LPCSTR strBuffer); // 1.61

long WINAPI
IPS7RdStr (long Ref, DWORD Typ,  DWORD DBNr, DWORD Start, DWORD Cnt, LPSTR Buffer); // 1.61


long WINAPI
IPS7ReadDiagBuffer (long Ref, S7_EVENTENTRY *pEvent, int MaxEvents, int *pRxEventCnt); // 1.68

long WINAPI 
IPS7SetTCPPort (long Ref, unsigned long Port); // 1.71.92

long WINAPI
IPS7RdMultiCalcPacketCnt (long Ref, IPS7_RQ_MULTI *pRqList, DWORD Cnt); // 1.39

long WINAPI
IPS7RdULInt (long Ref, DWORD Typ, DWORD DBNr, DWORD Start, DWORD Cnt, UINT64 *Buffer); // 64 Bit unsigned 1.73 
/* ------------------------------------------------------------------ */

long WINAPI
IPS7RdLInt (long Ref, DWORD Typ, DWORD DBNr, DWORD Start, DWORD Cnt, INT64 *Buffer); // 64 Bit signed 1.73 
/* ------------------------------------------------------------------ */

long WINAPI
IPS7WrULInt (long Ref, DWORD Typ, DWORD DBNr, DWORD Start, DWORD Cnt, UINT64 *Buffer); // 64 Bit unsigned 1.73 
/* ------------------------------------------------------------------ */

long WINAPI
IPS7WrLInt (long Ref, DWORD Typ, DWORD DBNr, DWORD Start, DWORD Cnt, INT64 *Buffer); // 64 Bit signed 1.73 
/* ------------------------------------------------------------------ */

long WINAPI
IPS7OpenExWithTSAP (LPCTSTR IPAdr, DWORD Rack, DWORD Slot, DWORD SubNetId, DWORD DstMPIAdr, DWORD AccessMode, DWORD RxTimeout, DWORD TxTimeout, DWORD ConnectTimeout, BYTE *LocalTSAP, BYTE* RemoteTSAP); //1.77

long WINAPI IPS7GetDBLen(long Ref, unsigned long DBNr); // 1.78


#ifndef __linux__
 #pragma  pack (pop)
#endif


#ifdef __cplusplus
}
#endif 

#endif // _IPS7LNK_H_45632
