VERSION 5.00
Begin VB.Form EasyDemo 
   Caption         =   "IP-S7-LINK Demoprogramm fr Visual Basic 6.0"
   ClientHeight    =   7665
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8310
   LinkTopic       =   "Form1"
   ScaleHeight     =   7665
   ScaleWidth      =   8310
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton IPS7RdMultiCmd 
      Caption         =   "IPS7RdMulti (MultiRead)"
      Height          =   375
      Left            =   4560
      TabIndex        =   30
      ToolTipText     =   "Liest von der SPS ab Startadresse Anzahl Bytes"
      Top             =   3840
      Width           =   2895
   End
   Begin VB.CommandButton IPS7RdStrCmd 
      Caption         =   "IPS7RdString (Read String)"
      Height          =   375
      Left            =   4560
      TabIndex        =   29
      ToolTipText     =   "Liest von der SPS ab Startadresse Anzahl Bytes"
      Top             =   3240
      Width           =   2895
   End
   Begin VB.ComboBox cbPlCType 
      Height          =   315
      ItemData        =   "IPS7DEMO.frx":0000
      Left            =   240
      List            =   "IPS7DEMO.frx":000A
      TabIndex        =   27
      Text            =   "Combo1"
      Top             =   1560
      Width           =   1695
   End
   Begin VB.OptionButton rbUsePG 
      Caption         =   "PG"
      Height          =   255
      Left            =   3480
      TabIndex        =   26
      Top             =   1560
      Width           =   615
   End
   Begin VB.OptionButton rbUseOP 
      Caption         =   "OP"
      Height          =   255
      Left            =   2520
      TabIndex        =   25
      Top             =   1560
      Width           =   615
   End
   Begin VB.Frame Frame1 
      Caption         =   "Kanal/Channel"
      Height          =   735
      Left            =   2160
      TabIndex        =   24
      Top             =   1320
      Width           =   2175
   End
   Begin VB.CommandButton IPS7RdDWCmd 
      Caption         =   "IPS7Rd&DW (....), Doppelwort lesen"
      Height          =   375
      Left            =   4560
      TabIndex        =   23
      ToolTipText     =   "Liest von der SPS ab Startadresse Anzahl Bytes"
      Top             =   2280
      Width           =   2895
   End
   Begin VB.CommandButton IPS7RdFP 
      Caption         =   "IPS7Rd&FP (....), REAL lesen"
      Height          =   375
      Left            =   4560
      TabIndex        =   22
      ToolTipText     =   "Liest von der SPS ab Startadresse Anzahl Bytes"
      Top             =   2760
      Width           =   2895
   End
   Begin VB.TextBox SlotNrEdit 
      Height          =   285
      Left            =   3120
      TabIndex        =   20
      Text            =   "2"
      Top             =   840
      Width           =   1215
   End
   Begin VB.TextBox RackNrEdit 
      Height          =   285
      Left            =   3120
      TabIndex        =   19
      Text            =   "0"
      Top             =   480
      Width           =   1215
   End
   Begin VB.TextBox IPAdrEdit 
      Height          =   285
      Left            =   3120
      TabIndex        =   18
      Text            =   "192.168.0.80"
      Top             =   120
      Width           =   1215
   End
   Begin VB.PictureBox Logo 
      Height          =   1695
      Left            =   4560
      ScaleHeight     =   1635
      ScaleWidth      =   2835
      TabIndex        =   17
      Top             =   4440
      Width           =   2895
   End
   Begin VB.TextBox DBNrEingabe 
      Alignment       =   1  'Rechts
      Height          =   315
      Left            =   1920
      MaxLength       =   5
      TabIndex        =   15
      Text            =   "1"
      Top             =   2640
      Width           =   615
   End
   Begin VB.CommandButton IPS7RdWCmd 
      Caption         =   "IPS7Rd&W (....), Worte lesen"
      Height          =   375
      Left            =   4560
      TabIndex        =   14
      ToolTipText     =   "Liest von der SPS ab Startadresse Anzahl Worte"
      Top             =   1800
      Width           =   2895
   End
   Begin VB.CommandButton IPS7RdBCmd 
      Caption         =   "IPS7Rd&B (....), Bytes lesen"
      Height          =   375
      Left            =   4560
      TabIndex        =   10
      ToolTipText     =   "Liest von der SPS ab Startadresse Anzahl Bytes"
      Top             =   1320
      Width           =   2895
   End
   Begin VB.TextBox AnzahlEingabe 
      Alignment       =   1  'Rechts
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0,0;(0,0)"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1031
         SubFormatType   =   1
      EndProperty
      Height          =   315
      Left            =   3600
      TabIndex        =   9
      Text            =   "Anzahl"
      Top             =   2640
      Width           =   735
   End
   Begin VB.TextBox StartAdresseEingabe 
      Alignment       =   1  'Rechts
      Height          =   315
      Left            =   2760
      TabIndex        =   8
      Text            =   "Start"
      Top             =   2640
      Width           =   735
   End
   Begin VB.ComboBox DatenArtBox 
      Height          =   315
      ItemData        =   "IPS7DEMO.frx":0027
      Left            =   240
      List            =   "IPS7DEMO.frx":003D
      Style           =   2  'Dropdown-Liste
      TabIndex        =   7
      Top             =   2640
      Width           =   1575
   End
   Begin VB.TextBox StatusBox 
      BackColor       =   &H00FFFFFF&
      Height          =   525
      Left            =   240
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      TabIndex        =   5
      Text            =   "IPS7DEMO.frx":006E
      ToolTipText     =   "Status der ausgefhrten Funktion bzw.Fehlernummer"
      Top             =   6480
      Width           =   7215
   End
   Begin VB.ListBox DataList 
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0,0000%"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1031
         SubFormatType   =   5
      EndProperty
      Height          =   2985
      Left            =   240
      TabIndex        =   4
      ToolTipText     =   "Ergebnis der Leseoperation"
      Top             =   3120
      Width           =   4095
   End
   Begin VB.CommandButton IPS7CloseCmd 
      Caption         =   "IPS7&Close (Ref)"
      Height          =   375
      Left            =   4560
      TabIndex        =   3
      ToolTipText     =   "Schliet die mit IPS7Open geffnete Verbindung"
      Top             =   600
      Width           =   2895
   End
   Begin VB.CommandButton IPS7OpenCmd 
      Caption         =   "Ref = IPS7&Open (...)"
      Height          =   375
      Left            =   4560
      TabIndex        =   2
      ToolTipText     =   "ffnet eine Verbindung mit den gewnschten Parametern"
      Top             =   120
      Width           =   2895
   End
   Begin VB.Label Label9 
      Caption         =   "SPS-Typ / PLC-Type"
      Height          =   255
      Left            =   240
      TabIndex        =   28
      Top             =   1200
      Width           =   1575
   End
   Begin VB.Label Label8 
      Alignment       =   1  'Rechts
      Caption         =   "Slot-Nummer:"
      Height          =   255
      Left            =   1800
      TabIndex        =   21
      Top             =   840
      Width           =   1215
   End
   Begin VB.Label Label4 
      Caption         =   "DBNr:"
      Height          =   255
      Left            =   1920
      TabIndex        =   16
      Top             =   2400
      Width           =   735
   End
   Begin VB.Label Label7 
      Caption         =   "Anzahl:"
      Height          =   255
      Left            =   3600
      TabIndex        =   13
      Top             =   2400
      Width           =   735
   End
   Begin VB.Label Label6 
      Caption         =   "Startadr.:"
      Height          =   255
      Left            =   2760
      TabIndex        =   12
      Top             =   2400
      Width           =   735
   End
   Begin VB.Label Label5 
      Caption         =   "Datenbereich data area:"
      Height          =   495
      Left            =   240
      TabIndex        =   11
      Top             =   2160
      Width           =   1095
   End
   Begin VB.Label Label3 
      Caption         =   "Status:"
      Height          =   255
      Left            =   240
      TabIndex        =   6
      Top             =   6240
      Width           =   615
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Rechts
      Caption         =   "Rack-Nummer:"
      Height          =   255
      Left            =   1800
      TabIndex        =   1
      Top             =   480
      Width           =   1215
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Rechts
      Caption         =   "TCP/IP-Adresse:"
      Height          =   255
      Left            =   1800
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "EasyDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim IPAdresse As String
Dim RackNr As Long
Dim SlotNr As Long
Dim Ref As Long


Dim ErrText As String
Dim DBNr As Long
Dim StartAdresse As Long
Dim DatenArt As Long
Dim Anzahl As Long
Dim Res As Long
Dim ByteBuffer(0 To 2048) As Byte
Dim WordBuffer(0 To 2048) As Integer
Dim DoubleBuffer(0 To 2048) As Double
Dim DWordBuffer(0 To 2048) As Long

Dim AccessMode As Long



Private Function GetErrText(Res As Long) As String


Dim SockErr As Long
Dim SockErrStr As String


ErrText = "Fehler:"

ErrText = Switch(Res = 0, "Lesen OK", _
          Res = -1, "Zeitberlauf Kabel oder Partner nicht vorhanden", _
          Res = -2, "Keine Resourcen mehr frei", _
          Res = -3, "Referenz war nicht geffnet", _
          Res = 2, "Datenbereich zu klein oder nicht vorhanden", _
          Res = -6, "Ziel-SPS nicht gefunden", _
          Res = -7, "Socketfehler aufgetreten", _
          Res = -8, "Speicheranforderungsfehler aufgetreten", _
          Res = -9, "Ein Wert berschreitet den Bereich: (z.B. T = 0 - Timer > 9990000 ms Zhler > 999)", _
          Res = -10, "Datentyp wird von dieser Funktion nicht untersttzt, versuchen Sie es mit einem anderen Kommando", _
          Res = -99, "Referenznummer falsch", _
          Res = 4660, "Demozeit abgelaufen")
If Res = -7 Then  'Socket Fehler
  SockErrStr = IPS7GetSockErr(Ref)
  
  ErrText = ErrText + " Nummer: " + SockErrStr
End If

StatusBox.Text = ErrText
If Res <> 0 Then
  StatusBox.BackColor = &H8080FF
Else
  StatusBox.BackColor = &H80000005
End If

If Res <> 0 Then
  MsgBox "Es ist ein Fehler aufgetreten:" + ErrText, vbOKOnly
End If
GetErrText = ErrText

End Function

Private Function GetErrTextOnOpen(Res As Long) As String
ErrText = "Fehler:"
ErrText = Switch(Res >= 0, "Verbindung ist geffnet", _
          Res = -2, "Keine Resourcen mehr frei", _
          Res = 4660, "Demozeit abgelaufen")
          
StatusBox.Text = ErrText
If Res < 0 Then
  StatusBox.BackColor = &H8080FF
Else
  StatusBox.BackColor = &H80000005
End If
GetErrTextOnOpen = ErrText
End Function

Private Sub IPS7CloseCmd_Click()
IPS7Close (Ref)
IPS7RdBCmd.Enabled = False
IPS7RdWCmd.Enabled = False
IPS7CloseCmd.Enabled = False
IPS7OpenCmd.Enabled = True

IPAdrEdit.Enabled = True
cbPlCType.Enabled = True
rbUseOP.Enabled = True
rbUsePG.Enabled = True
SlotNrEdit.Enabled = True
RackNrEdit.Enabled = True




Ref = -1
StatusBox.Text = "Bitte Funktion whlen"
StatusBox.BackColor = &H80000005

End Sub

Private Function GetData(bWord As Boolean) As Boolean
GetData = False
DBNr = DBNrEingabe.Text
StartAdresse = StartAdresseEingabe.Text
Anzahl = AnzahlEingabe.Text
DatenArt = Asc(DatenArtBox.Text)
If DatenArt = Asc("Z") Or DatenArt = Asc("T") Then
  bWord = False
End If
If Anzahl <= 0 Or Anzahl > 2048 Then
  MsgBox "Anzahl ist ungltig: Eingabe 1 .. 2048", vbOKOnly
Exit Function
End If

If DBNr < 0 Or DBNr > 65535 Then
  MsgBox "Datenbausteinnumer ist ungltig: Eingabe 0 .. 65535", vbOKOnly
Exit Function
End If

If StartAdresse < 0 Or StartAdresse > 65535 Then
  MsgBox "Startadresse ist ungltig: Eingabe 0 .. 65535", vbOKOnly
Exit Function
End If
If bWord = True Then
  If StartAdresse Mod 2 <> 0 Then
    MsgBox "Es sind nur gerade Startadressen zugelassen: Eingabe 0, 2,4 .", vbOKOnly
  End If
End If
GetData = True
End Function
Private Sub IPS7OpenCmd_Click()
SlotNr = SlotNrEdit.Text
RackNr = RackNrEdit.Text
IPAdresse = IPAdrEdit.Text
'Ref = IPS7Open(IPAdresse, RackNr, SlotNr, 500, 500, 500)
GetAccessMode
Ref = IPS7OpenEx(IPAdresse, RackNr, SlotNr, 0, 0, AccessMode, 500, 500, 500)
GetErrTextOnOpen (Ref)
If Ref >= 0 Then
  IPS7OpenCmd.Enabled = False
  IPS7RdBCmd.Enabled = True
  IPS7RdWCmd.Enabled = True
  IPS7CloseCmd.Enabled = True
  
  IPAdrEdit.Enabled = False
  cbPlCType.Enabled = False
  rbUseOP.Enabled = False
  rbUsePG.Enabled = False
  SlotNrEdit.Enabled = False
  RackNrEdit.Enabled = False
     
  
End If
End Sub

Private Sub IPS7RdBCmd_Click()
Dim Help As String
Dim i As Integer
Dim ListText As String

If GetData(False) = True Then
  Screen.MousePointer = vbHourglass
  Res = IPS7RdB(Ref, DatenArt, DBNr, StartAdresse, Anzahl, ByteBuffer(0))
  Screen.MousePointer = vbDefault
  GetErrText (Res)
  If Res = 0 Then
    DataList.Clear
    Help = Switch(DatenArt = Asc("M"), "MB", _
            DatenArt = Asc("E"), "EB", _
            DatenArt = Asc("A"), "AB", _
            DatenArt = Asc("D"), "DB")
    
    For i = 0 To Anzahl - 1
    ListText = Help + Format(i + StartAdresse, "#####0000") + "=" + Format(ByteBuffer(i), "######00000")
    DataList.AddItem (ListText)
    Next i
    'Liste fllen und anzeigen
  End If
End If
End Sub

Private Sub IPS7RdDWCmd_Click()
Dim Help As String
Dim ListText As String
Dim i As Integer
If GetData(False) = True Then
  Screen.MousePointer = vbHourglass
  Res = IPS7RdDW(Ref, DatenArt, DBNr, StartAdresse, Anzahl, DWordBuffer(0))
  Screen.MousePointer = vbDefault
  GetErrText (Res)
  
  If Res = 0 Then
    DataList.Clear
    Help = Switch(DatenArt = Asc("M"), "MD", _
            DatenArt = Asc("E"), "ED", _
            DatenArt = Asc("A"), "AD", _
            DatenArt = Asc("T"), "T", _
            DatenArt = Asc("D"), "DB" + Format(DBNr, "###") + ".DBD")
    If DatenArt = Asc("T") Then
      For i = 0 To Anzahl - 1
        ListText = Help + Format(i + StartAdresse, "#####0000") + "=" + Format(DWordBuffer(i), "######00000" + " ms")
        DataList.AddItem (ListText)
      Next i
    Else
      For i = 0 To Anzahl - 1
        ListText = Help + Format(i * 4 + StartAdresse, "#####0000") + "=" + Format(DWordBuffer(i), "######00000")
        DataList.AddItem (ListText)
      Next i
    End If
  End If
End If
End Sub

Private Sub IPS7RdFP_Click()
Dim Help As String
Dim ListText As String
Dim i As Integer
If GetData(False) = True Then
  Screen.MousePointer = vbHourglass
  Res = IPS7RdReal(Ref, DatenArt, DBNr, StartAdresse, Anzahl, DoubleBuffer(0))
   
  Screen.MousePointer = vbDefault
  GetErrText (Res)
  
  If Res = 0 Then
    DataList.Clear
    Help = Switch(DatenArt = Asc("M"), "ab MB", _
            DatenArt = Asc("E"), "ab EB", _
            DatenArt = Asc("A"), "ab ", _
            DatenArt = Asc("D"), "ab DB" + Format(DBNr, "###") + ".DBB")
    For i = 0 To Anzahl - 1
      ListText = Help + Format(i * 4 + StartAdresse, "#####0000") + "=" + Format(DoubleBuffer(i), "0.00000")
      DataList.AddItem (ListText)
    Next i
  End If
End If

End Sub

Private Function InitRq(pRq As IPS7_RQ_MULTI, ByVal DataArea&, ByVal DataType&, _
                        ByVal PcDataType&, ByVal DBNr&, _
                        ByVal StartByte&, ByVal StartBit&, ByVal Cnt&, pData As Long)
  pRq.DataArea = DataArea
  pRq.DataType = DataType
  pRq.DBNr = DBNr
  pRq.Cnt = Cnt
  pRq.Start = StartByte
  pRq.StartBit = StartBit
  pRq.PcDataType = PcDataType
  pRq.Data = pData
End Function

Private Sub IPS7RdMultiCmd_Click()
Dim Rq(0 To 1) As IPS7_RQ_MULTI
Dim i As Integer
Dim ListText As String

If GetData(True) = True Then
  Screen.MousePointer = vbHourglass
  

  Call InitRq(Rq(0), Asc("D"), IPS7_BYTE, PC_BYTE, 100, 0, 0, 200, VarPtr(ByteBuffer(0)))    'read DB 100 at Byte 0 200 Bytes to ByteBuffer(0)
  Call InitRq(Rq(1), Asc("D"), IPS7_BYTE, PC_BYTE, 1000, 0, 0, 200, VarPtr(ByteBuffer(200))) 'read DB 1000 at Byte 0 200 Bytes to ByteBuffer(200)
  Res = IPS7RdMulti(Ref, Rq(0), 2)
  Screen.MousePointer = vbDefault
  GetErrText (Res)
  If Res = 0 Then
    DataList.Clear
    
    For i = 0 To 200 - 1
    ListText = "DB100 DBB" + Format(i + StartAdresse, "#####0000") + "=" + Format(ByteBuffer(i), "######00000")
    DataList.AddItem (ListText)
    Next i
    
    For i = 0 To 200 - 1
    ListText = "DB1000 DBB" + Format(i + StartAdresse, "#####0000") + "=" + Format(ByteBuffer(i + 200), "######00000")
    DataList.AddItem (ListText)
    Next i

  End If
End If

End Sub

Private Sub IPS7RdStrCmd_Click()
Dim TestString As String * 2048
If GetData(True) = True Then
  Screen.MousePointer = vbHourglass
  Res = IPS7RdStr(Ref, DatenArt, DBNr, StartAdresse, Anzahl, TestString)
  Screen.MousePointer = vbDefault
  GetErrText (Res)
  If Res = 0 Then
    DataList.Clear
    DataList.AddItem (TestString)
  End If
End If
End Sub


Private Sub IPS7RdWCmd_Click()
Dim Help As String
Dim ListText As String
Dim i As Integer
If GetData(True) = True Then
  Screen.MousePointer = vbHourglass
  Res = IPS7RdW(Ref, DatenArt, DBNr, StartAdresse / 2, Anzahl, WordBuffer(0))
  Screen.MousePointer = vbDefault
  GetErrText (Res)
  
  If Res = 0 Then
    DataList.Clear
    Help = Switch(DatenArt = Asc("M"), "MW", _
            DatenArt = Asc("E"), "EW", _
            DatenArt = Asc("A"), "AW", _
            DatenArt = Asc("Z"), "Z", _
            DatenArt = Asc("D"), "DB" + Format(DBNr, "###") + ".DBW")
    If DatenArt = Asc("Z") Then
     For i = 0 To Anzahl - 1
        ListText = Help + Format(i + StartAdresse, "#####0000") + "=" + Format(WordBuffer(i), "######00000")
        DataList.AddItem (ListText)
      Next i
    Else
      For i = 0 To Anzahl - 1
        ListText = Help + Format(i * 2 + StartAdresse, "#####0000") + "=" + Format(WordBuffer(i), "######00000")
        DataList.AddItem (ListText)
      Next i
    End If
  End If
End If
End Sub

Private Sub GetAccessMode()
If cbPlCType.ListIndex = 0 Then ' S7 300/400/1200
  If rbUseOP.Value = True Then
    AccessMode = 0
  Else
    AccessMode = 1
  End If
Else ' S7 200
  AccessMode = 2
End If

End Sub
Private Sub Form_Load()
Dim Fs As Object
Set Fs = CreateObject("Scripting.FileSystemObject")
If (Fs.FileExists(App.Path + "\OEM.BMP") = True) Then
  Logo.Picture = LoadPicture(App.Path + "\OEM.BMP")
End If
DatenArtBox.ListIndex = 0
StartAdresseEingabe.Text = 0
AnzahlEingabe.Text = 1
IPS7RdBCmd.Enabled = False
IPS7RdWCmd.Enabled = False
IPS7CloseCmd.Enabled = False
cbPlCType.ListIndex = 0
rbUseOP.Value = True

Ref = -1
End Sub






