%> @file SimaticChannelType.m
% This file is protected by TIS
% Copyright  2013-2022.

% SimaticChannelType
%>   Specifies how a connection will operate on the device.
classdef SimaticChannelType < int32
    %> The definition of the SimaticChannelType enumeration.
    enumeration
        %> The default SimaticChannelType (@b OperationPanel) is used by
        %> the connection.
        Default (0)

        %> The connection will perform simple read/write operations on a
        %> device. A connection of this type (OP) operates as a simple human
        %> machine interface (HMI).
        OperationPanel (1)

        %> The connection will perform extended read/write operations on a
        %> device. A connection of this type operates as a programmer
        %> device.
        ProgrammerDevice (2)

        %> A connection of this type operates in an different meaning like a
        %> PLC to PLC communication.
        Other (3)
    end % enumeration
end
