%> @file SimaticDeviceType.m
% This file is protected by TIS
% Copyright  2013-2022.

% SimaticDeviceType
%>   Defines the different device types supported by the SimaticDevice.
classdef SimaticDeviceType < int32
    %> The definition of the SimaticDeviceType enumeration.
    enumeration
        %> The Siemens LOGO! is a DDC-Module (Direct Digital Control), which
        %> represents a small programmable logic controller (PLC).
        Logo (0)

        %> The Siemens Simatic S7-200, the smallest programmable logic
        %> controller (PLC) provided by the Siemens AG.
        S7200 (1)

        %> The Siemens Simatic S7-300 and S7-400, most common and the
        %> biggest programmable logic controller (PLC) provided by the
        %> Siemens AG.
        S7300_400 (2)

        %> The Siemens Simatic S7-1200, the official successor of the
        %> Siemens Simatic S7-200 (S7200) since 2009.
        S71200 (3)

        %> The Siemens Simatic S7-1500, the official successor of the
        %> Siemens Simatic S7-300 and S7-400 (S7300_400) since 2012.
        S71500 (4)
    end % enumeration
end

