%> @file PlcDeviceConnectionState.m
% This file is protected by TIS
% Copyright  2013-2022.

% PlcDeviceConnectionState
%>   Defines the states in which a PlcDeviceConnection can exist.
classdef PlcDeviceConnectionState < int32
    %> The definition of the PlcDeviceConnectionState enumeration.
    enumeration
        %> Indicates that the connection has been instantiated and is
        %> configurable, but not yet open or ready for use.
        Created (0)

        %> Indicates that the connection is being transitioned from the
        %> Created state to the Opened state. During this state does the
        %> connection try to establish a connection to a device.
        Opening (1)

        %> Indicates that the connection is now open and ready to be used,
        %> because of the successfully established connection to a device.
        Opened (2)

        %> Indicates that the connection is being transitioned from the Opened
        %> state to the Connected state. During this state does the connection try
        %> to fully establish a connection to a device.
        Connecting (3)

        %> Indicates that the connection is now fully established to a device.
        Connected (4)

        %> Indicates that a previously fully established connection or an attempt to connect to a
        %> device has been broken/failed.
        Disconnected (5)

        %> Indicates that the connection has encountered an error or fault
        %> from which it cannot recover and from which it is no longer
        %> usable.
        Faulted (6)

        %> Indicates that the connection is transitioning to the Closed
        %> state. During this state does the connection try to close an
        %> previously opened connection to a device.
        Closing (7)

        %> Indicates that the connection has been closed to a device.
        Closed (8)
    end % enumeration
end