%> @file PlcTypeCode.m
% This file is protected by TIS
% Copyright  2013-2022.

% PlcTypeCode
%>   Specifies the type of a PLC object.
classdef PlcTypeCode < int32
    %> The definition of the PlcTypeCode enumeration.
    enumeration
        %> A null reference.
        Empty (0)

        %> A type representing a logical value.
        Bool (1)

        %> A type representing a binary value.
        Byte (2)

        %> A type representing a single character.
        Char (3)

        %> A type representing an int16.
        Int (4)

        %> A type representing an uint16.
        Word (5)

        %> A type representing an int32.
        DInt (6)

        %> A type representing an uint32.
        DWord (7)

        %> A type representing a single.
        Real (8)

        %> A type representing a double.
        Double (9)

        %> A type representing a date number (containing only the date of day).
        Date (10)

        %> A type representing a date number (containing only the time of day).
        Time (11)

        %> A type representing a date number (containing only the time of day).
        TimeOfDay (12)

        %> A type representing a date number (containing only the time of day).
        S5Time (13)

        %> A type representing a date number.
        DateTime (14)

        %> A type representing a string.
        String (15)
    end % enumeration
end

