%> @file PlcUInt16.m
% This file is protected by TIS
% Copyright  2013-2022.

% PlcUInt16
%>   Represents an uint16 value (in PLC a WORD) its value defines a 16-bit unsigned integer value.
classdef PlcUInt16 < PlcValue    
    % ---------- Public properties ----------
    properties (Access = public, Dependent = true)
        %> @brief Gets or sets the value assigned to the PLC value.
        %>   The value assigned to the PLC value.
        Value;
    end % properties

    % ---------- Public constructors ----------
    methods (Access = public)
        %> @brief Initializes a new instance of the PlcUInt16 class using the specified @b address and @b value.
        %>
        %> @param address The PlcAddress of the new PlcUInt16 to which the PLC
        %>                value belongs.
        %> @param value The initial value of the new PlcUInt16.
        %>
        %> @b Errors
        %> * The @b address does not refer to the @b PlcRawType.Word.
        function this = PlcUInt16(address, value)
            superArguments{1} = PlcTypeCode.Word;
            superArguments{2} = address;
            superArguments{3} = 0; % Length

            if (nargin == 2)
                superArguments{4} = System.Convert.ToUInt16(value);
            else
                superArguments{4} = System.Convert.ToUInt16(0);
            end

            this = this@PlcValue( ...
                    superArguments{1}, ...
                    superArguments{2}, ...
                    superArguments{3}, ...
                    superArguments{4});
        end
    end % methods

    % ---------- Property accessors ----------
    methods
        %> Gets the value assigned to the PLC value.
        function value = get.Value(this)
            value = this.ManagedInstance.GetValue('Value');
        end

        %> Sets the value assigned to the PLC value.
        function set.Value(this, value)
            this.ManagedInstance.SetValue('Value', System.Convert.ToUInt16(value));
        end
    end % methods
end

