%> @file SimaticDeviceConnection.m
% This file is protected by TIS
% Copyright  2013-2022.

% SimaticDeviceConnection
%>   Represents a connection to a SimaticDevice.
classdef SimaticDeviceConnection < PlcDeviceConnection
    % ---------- Public constructors ----------
    methods (Access = public)
        %> @brief Initializes a new instance of the SimaticDeviceConnection class using the specified device.
        %>
        %> @param device The SimaticDevice associated with the new
        %>               SimaticDeviceConnection.
        %>
        %> @b Errors
        %> * The @b device is not an instance of the SimaticDevice class.
        function this = SimaticDeviceConnection(device)
            SimaticMatLabToolbox.Start();
            
            if (~isa(device, 'SimaticDevice'))
                error('The device needs to be an instance of the SimaticDevice class.');
            end
            
            this = this@PlcDeviceConnection(device);
            this.ManagedInstance = IPS7Lnk.Advanced.MatLab.Factory.CreateConnection(device.ManagedInstance);
            
            %> TODO: Needs to be implemented.
            %> addlistener(this.ManagedInstance, 'Closed', @this.HandleManagedInstanceClosed);
            %> addlistener(this.ManagedInstance, 'Closing', @this.HandleManagedInstanceClosing);
            %> addlistener(this.ManagedInstance, 'Connecting', @this.HandleManagedInstanceConnecting);
            %> addlistener(this.ManagedInstance, 'Connected', @this.HandleManagedInstanceConnected);
            %> addlistener(this.ManagedInstance, 'Disconnected', @this.HandleManagedInstanceDisconnected);
            %> addlistener(this.ManagedInstance, 'Faulted', @this.HandleManagedInstanceFaulted);
            %> addlistener(this.ManagedInstance, 'Opened', @this.HandleManagedInstanceOpened);
            %> addlistener(this.ManagedInstance, 'Opening', @this.HandleManagedInstanceOpening);
        end
    end % methods

    % ---------- Private static methods ----------
    methods (Access = private)
        function HandleManagedInstanceClosed(this, sender, e)
            notify(this, 'Closed');
        end
        
        function HandleManagedInstanceClosing(this, sender, e)
            notify(this, 'Closing');
        end

        function HandleManagedInstanceConnected(this, sender, e)
            notify(this, 'Connected');
        end

        function HandleManagedInstanceConnecting(this, sender, e)
            notify(this, 'Connecting');
        end

        function HandleManagedInstanceDisconnected(this, sender, e)
            notify(this, 'Disconnected');
        end

        function HandleManagedInstanceFaulted(this, sender, e)
            notify(this, 'Faulted');
        end
        
        function HandleManagedInstanceOpened(this, sender, e)
            notify(this, 'Opened');
        end
        
        function HandleManagedInstanceOpening(this, sender, e)
            notify(this, 'Opening');
        end
    end % methods
end

