%> @file PlcArray.m
% This file is protected by TIS
% Copyright  2013-2022.

% PlcArray
%>   Represents an abstract base class of PLC arrays.
classdef (Abstract = true) PlcArray < PlcValue
    % ---------- Public properties ----------
    properties (GetAccess = public, Dependent = true)
        %> @brief Gets a 32-bit integer that represents the total number of elements within the array.
        %>   A 32-bit integer that represents the total number of elements
        %>   within the array.
        Length;
    end % properties
    
    % ---------- Protected constructors ----------
    methods (Access = protected)
        %> @brief Initializes a new instance of the PlcArray class using the specified @b typeCode, @b address and @b values.
        %>
        %> @param typeCode One of the members defined by the PlcTypeCode
        %>                 enumeration class which defines the concrete type of
        %>                 values represented.
        %> @param address The PlcAddress of the new PlcArray to which the PLC        
        %>                values belong.
        %> @param values The initial values of the new PlcArray.
        function this = PlcArray(typeCode, address, values)
            this = this@PlcValue( ...
                    typeCode, ...
                    address, ...
                    values.Length, ...
                    values);
        end
    end % methods
    
    % ---------- Property accessors ----------
    methods
        %> Gets a 32-bit integer that represents the total number of elements within the array.
        function value = get.Length(this)
            value = this.ManagedInstance.GetValue('Type.Length');
        end
    end % methods
end

