%> @file PlcInt32.m
% This file is protected by TIS
% Copyright  2013-2022.

% PlcInt32
%>   Represents an int32 value (in PLC a DINT) its value defines a 32-bit signed integer value.
classdef PlcInt32 < PlcValue    
    % ---------- Public properties ----------
    properties (Access = public, Dependent = true)
        %> @brief Gets or sets the value assigned to the PLC value.
        %>   The value assigned to the PLC value.
        Value;
    end % properties

    % ---------- Public constructors ----------
    methods (Access = public)
        %> @brief Initializes a new instance of the PlcInt32 class using the specified @b address and @b value.
        %>
        %> @param address The PlcAddress of the new PlcInt32 to which the PLC
        %>                value belongs.
        %> @param value The initial value of the new PlcInt32.
        %>
        %> @b Errors
        %> * The @b address does not refer to the @b PlcRawType.DWord.
        function this = PlcInt32(address, value)
            superArguments{1} = PlcTypeCode.DInt;
            superArguments{2} = address;
            superArguments{3} = 0; % Length

            if (nargin == 2)
                superArguments{4} = System.Convert.ToInt32(value);
            else
                superArguments{4} = System.Convert.ToInt32(0);
            end

            this = this@PlcValue( ...
                    superArguments{1}, ...
                    superArguments{2}, ...
                    superArguments{3}, ...
                    superArguments{4});
        end
    end % methods

    % ---------- Property accessors ----------
    methods
        %> Gets the value assigned to the PLC value.
        function value = get.Value(this)
            value = this.ManagedInstance.GetValue('Value');
        end

        %> Sets the value assigned to the PLC value.
        function set.Value(this, value)
            this.ManagedInstance.SetValue('Value', System.Convert.ToInt32(value));
        end
    end % methods
end

