%> @file PlcOperandType.m
% This file is protected by TIS
% Copyright  2013-2022.

% PlcOperandType
%>   Specifies the different operands that can be used to access a programmable logic controller (PLC).
classdef PlcOperandType < int32
    %> The definition of the PlcOperandType enumeration.
    enumeration
        %> The operand used to access input areas of the controller.
        Input (0)

        %> The operand used to access periphery input areas of the controller.
        PeripheryInput (1)

        %> The operand used to access output areas of the controller.
        Output (2)

        %> The operand used to access periphery output areas of the controller.
        PeripheryOutput (3)

        %> The operand used to access flag areas of the controller.
        Flag (4)

        %> The operand used to access data block areas of the controller.
        DataBlock (5)

        %> The operand used to access counter areas of the controller.
        Counter (6)

        %> The operand used to access timer areas of the controller.
        Timer (7)
    end % enumeration
end

