%> @file PlcRawType.m
% This file is protected by TIS
% Copyright  2013-2022.

% PlcRawType
%>   Specifies the different raw types that can be used for read/write operations using a PlcAddress on a programmable logic controller (PLC).
classdef PlcRawType < int32
    %> The definition of the PlcRawType enumeration.
    enumeration
        %> Defines a binary type its binary length in bits is restricted to
        %> 1 bit.
        Bit (0)
        
        %> Defines a binary type its binary length in bits is restricted to
        %> 8 bits.
        Byte (1)
        
        %> Defines a binary type its binary length in bits is restricted to
        %> 16 bits.
        Word (2)
        
        %> Defines a binary type its binary length in bits is restricted to
        %> 32 bits.
        DWord (3)
    end % enumeration
end

