%> @file SimaticMatLabToolbox.m
% This file is protected by TIS
% Copyright © 2013-2022.

% SimaticMatLabToolbox
%>   Provides a set of static functions for the toolbox.
classdef SimaticMatLabToolbox
    % ---------- Public static methods ----------
    methods (Static)
        function Start()
            % App
            [appPath, name, ext] = fileparts(mfilename('fullpath'));
            assemblyPath = fullfile(appPath, 'IPS7LnkNet.Advanced.MatLab.dll');

            if (~(exist(assemblyPath, 'file')))
                % Fallback in toolbox root
                assemblyPath = fullfile(matlabroot, 'toolbox', 'IPS7LnkNet.Advanced.MatLab', 'IPS7LnkNet.Advanced.MatLab.dll');

                if (~(exist(assemblyPath, 'file')))
                    % Fallback in toolbox/matlab root
                    assemblyPath = fullfile(matlabroot, 'toolbox', 'matlab', 'IPS7LnkNet.Advanced.MatLab', 'IPS7LnkNet.Advanced.MatLab.dll');
                end
            end
    
            NET.addAssembly(assemblyPath);
        end
    end % methods

    % ---------- Property accessors ----------
    methods(Static)
        function value = ExpiryDate()
            SimaticMatLabToolbox.Start();
            value = IPS7Lnk.Advanced.MatLab.Licenser.GetExpiryDate();
        end

        function value = IsEvaluation()
            SimaticMatLabToolbox.Start();
            value = IPS7Lnk.Advanced.MatLab.Licenser.GetIsEvaluation();
        end

        function value = IsExpired()
            SimaticMatLabToolbox.Start();
            value = IPS7Lnk.Advanced.MatLab.Licenser.GetIsExpired();
        end

        function value = IsSupportExpired()
            SimaticMatLabToolbox.Start();
            value = IPS7Lnk.Advanced.MatLab.Licenser.GetIsSupportExpired();
        end

        function value = LicenseKey(value)
            SimaticMatLabToolbox.Start();

            if nargin
                IPS7Lnk.Advanced.MatLab.Licenser.SetLicenseKey(System.Convert.ToString(value));
            end

            value = IPS7Lnk.Advanced.MatLab.Licenser.GetLicenseKey();
        end

        function value = SupportExpiryDate()
            SimaticMatLabToolbox.Start();
            value = IPS7Lnk.Advanced.MatLab.Licenser.GetSupportExpiryDate();
        end    
    end % methods
end

