﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

Imports System.Text
Imports System.Windows
Imports System.Windows.Controls
Imports System.Windows.Documents
Imports System.ComponentModel
Imports System.Net
Imports System.Threading

Imports Rfc1006LibNet.Advanced
Imports Rfc1006LibNet.Advanced.EventArgs

Imports VB_Server_Graphical.VB_Server_Graphical

Namespace VB_Server_Graphical


    Partial Public Class TransferWindow
        Inherits Window
        Private server As Rfc1006Server

        Public Sub New(server As Rfc1006Server)
            InitializeComponent()

            Me.server = server

            '#Region "Connection Information"

            Me.tbIpAddress.Text = If((server.EndPoint.Address.Equals(IPAddress.None) = False), server.EndPoint.Address.ToString(), String.Empty)
            Me.tbPort.Text = server.EndPoint.Port.ToString()
            Me.tbLocalTsap.Text = Encoding.[Default].GetString(server.EndPoint.LocalTSAP)
            Me.tbRemoteTsap.Text = Encoding.[Default].GetString(server.EndPoint.RemoteTSAP)

            '#End Region

            '#Region "Configuration Information"

            Me.tbReceiveTiemout.Text = server.ReceiveTimeout.ToString()
            Me.tbTransmitTimeout.Text = server.TransmitTimeout.ToString()
            Me.tbAliveTime.Text = If((Me.server.AliveTime >= 0), Me.server.AliveTime.ToString(), String.Empty)

            '#End Region

            '#Region "1. Receive Option (currently not in use)"

            'receiveManuell();

            '#End Region

            '#Region "2. Receive Option (currently in use)"

            ' mount event after a receive was done
            Me.server.AutoReceive = True
            AddHandler Me.server.Received, AddressOf Me.server_Received

            '#End Region

            ' mount event at status changed
            AddHandler Me.server.StatusChanged, AddressOf Me.server_StatusChanged

            lbStatus.Content = Me.server.Status
        End Sub

#Region "1. Receive Option (currently not in use)"

        'Private Sub receiveManuell()
        '    Dim thread As Thread = New Thread(Sub()
        '                                Dim oldStatus As String = String.Empty
        '                                 While True
        '                                Try
        '                                                  Dim ret As String = server.ReceiveString()
        '                                                  Me.Dispatcher.InvokeAsync(New Action(Sub()
        '                                                                                           Me.tbReceived.Text = ret
        '                                                                                    End Sub),
        '                                                                       System.Windows.Threading.DispatcherPriority.DataBind)
        '                                          Catch generatedExceptionName As TimeoutException
        '                                        End Try
        '                                    End While

        '                           End Sub)
        '    Thread.Start()
        'End Sub

#End Region

#Region "2. Receive Option (currently in use)"

        Private Sub server_Received(sender As Object, e As TransferEventArgs)
            Me.Dispatcher.InvokeAsync(New Action(Sub()
                                                     Me.tbReceived.Text = Encoding.[Default].GetString(e.Buffer)

                                                     If cbEchoSend.IsChecked = True Then
                                                         Me.server.Transmit(Me.tbReceived.Text)
                                                     End If

                                                 End Sub), System.Windows.Threading.DispatcherPriority.DataBind)
        End Sub

#End Region

#Region "Transmit"

        Private Sub OnSend(sender As Object, e As RoutedEventArgs)
            Me.send()
        End Sub

        Private Sub OnTbSendTextChanged(sender As Object, e As TextChangedEventArgs)
            If Me.cbAutoSend.IsChecked = True Then
                Me.send()
            End If
        End Sub

        Private Sub send()
            Try
                ' get the text from the textbox
                Dim sendTxt As String = New TextRange(Me.tbSend.Document.ContentStart, Me.tbSend.Document.ContentEnd).Text

                ' send the whole text of the textbox to the stream
                Me.server.Transmit(sendTxt)
            Catch generatedExceptionName As TimeoutException
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End Sub

#End Region

#Region "Status & Configuration"

        Private Sub server_StatusChanged(sender As Object, e As StatusChangedEventArgs)
            Me.Dispatcher.InvokeAsync(New Action(Sub()
                                                     Me.lbStatus.Content = e.Status

                                                     If e.Exception IsNot Nothing AndAlso e.Status = Rfc1006Status.ConnectionClosing Then
                                                         Me.tbErrorMessage.Text = e.Exception.GetType().ToString() & vbLf & vbLf & Convert.ToString(e.Exception.Message)

                                                         Me.tbErrorMessage.Visibility = System.Windows.Visibility.Visible
                                                     ElseIf e.Status = Rfc1006Status.Connected Then
                                                         Me.ConfigurationInformationIsEnabled(False)
                                                         Me.tbErrorMessage.Visibility = System.Windows.Visibility.Hidden
                                                     End If

                                                 End Sub), System.Windows.Threading.DispatcherPriority.Send)
        End Sub

        Private Sub ConfigurationInformationIsEnabled(value As Boolean)
            Me.btStart.IsEnabled = value
            Me.btStop.IsEnabled = Not value

            Me.tbSend.IsEnabled = Not value
            Me.btSend.IsEnabled = Not value
            Me.cbAutoSend.IsEnabled = Not value

            Me.tbIpAddress.IsEnabled = value
            Me.tbPort.IsEnabled = value
            Me.tbLocalTsap.IsEnabled = value
            Me.tbRemoteTsap.IsEnabled = value
            Me.tbAliveTime.IsEnabled = value
        End Sub

        Private Sub OnWindowClosing(sender As Object, e As CancelEventArgs)
            Me.server.[Stop]()
            ' optional, will be done at disposing if not done by user  
            Environment.[Exit](0)
        End Sub

        Private Sub OnConfigurationChanged(sender As Object, e As RoutedEventArgs)
            '#Region "Connection Information"

            Dim address As IPAddress = IPAddress.None
            If IPAddress.TryParse(Me.tbIpAddress.Text, address) Then
                Me.server.EndPoint.Address = IPAddress.Parse(Me.tbIpAddress.Text)
            End If

            Me.server.EndPoint.Port = Int32.Parse(Me.tbPort.Text)
            Me.server.EndPoint.LocalTSAP = Encoding.[Default].GetBytes(Me.tbLocalTsap.Text)
            Me.server.EndPoint.RemoteTSAP = Encoding.[Default].GetBytes(Me.tbRemoteTsap.Text)

            '#End Region

            '#Region "Configuration Information"

            Me.server.ReceiveTimeout = Int32.Parse(Me.tbReceiveTiemout.Text)
            Me.server.TransmitTimeout = Int32.Parse(Me.tbTransmitTimeout.Text)
            Me.server.AliveTime = If((Me.tbAliveTime.Text <> [String].Empty), Int32.Parse(Me.tbAliveTime.Text), -1)

            '#End Region
        End Sub

        Private Sub OnStart(sender As Object, e As RoutedEventArgs)
            Me.ConfigurationInformationIsEnabled(False)

            Me.server.Start()
        End Sub

        Private Sub OnStop(sender As Object, e As RoutedEventArgs)
            Me.ConfigurationInformationIsEnabled(True)

            Me.server.[Stop]()
        End Sub

#End Region

        Private Sub OnHelp(sender As Object, e As RoutedEventArgs)
            System.Windows.Forms.Help.ShowHelp(Nothing, StartWindow.HelpPath)
        End Sub

        Private Sub OnInfo(sender As Object, e As RoutedEventArgs)
            System.Windows.Forms.Help.ShowHelp(Nothing, StartWindow.InfoPath)
        End Sub

        Private Sub OnExit(sender As Object, e As RoutedEventArgs)
            Me.server.[Stop]()
            ' optional, will be done at disposing if not done by user  
            Environment.[Exit](0)
        End Sub

        Private Sub OnCleanSend(sender As Object, e As RoutedEventArgs)
            Me.tbSend.Document.Blocks.Clear()
        End Sub

        Private Sub OnCleanReceive(sender As Object, e As RoutedEventArgs)
            Me.tbReceived.Text = String.Empty
        End Sub
    End Class
End Namespace