﻿// Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

namespace CS_Client_SimpleEchoTransmit
{
    using System;
    using Rfc1006LibNet.Advanced;

    /// <summary>
    /// This sample demonstrates a Hello World! application.
    /// </summary>
    /// <remarks>
    /// This application does write/read the 'Hello World!' message via RFC1006
    /// and prints the message on the standard output 
    /// from a client perspective with any RFC1006 client.
    /// </remarks>
    public class Program
    {
        public static void Main(string[] args)
        {
            // Connect to any RFC1006 client 
            // using the specified IP and TSAPs and the default values 
            // for the not defined attributes 
            // like port, connection timeout, receive timeout...
            Console.WriteLine("1) Starting client... \n");
            Rfc1006Client client = new Rfc1006Client("127.0.0.1", "localTSAP", "remoteTSAP");
            client.Connect();

            while (true) {
                try {
                    // Receive a package and transmit the same buffer back to the server.
                    Console.WriteLine("###########################################################");
                    Console.WriteLine("2) Receiving... \n");
                    string ret = client.ReceiveString();
                    Console.WriteLine("Received: " + ret);

                    Console.WriteLine("###########################################################");
                    Console.WriteLine("3) Transmitting... \n");
                    client.Transmit(ret);
                }
                catch (TimeoutException) {
                    Console.WriteLine("Server did not transmit a package in " + client.ReceiveTimeout + " milliseconds.");
                }
            }
        }
    }
}
