﻿// Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

namespace CS_Server_Graphical
{
    using System;
    using System.Net;
    using System.Windows;

    using Rfc1006LibNet.Advanced;

    public partial class StartWindow : Window
    {
        public static readonly string HelpPath = "http://wiki.traeger.de";
        public static readonly string InfoPath = "http://www.traeger.de";

        public StartWindow()
        {
            InitializeComponent();
        }

        private void btnStart_Click(object sender, RoutedEventArgs e)
        {
            try {
                Rfc1006Server server = null;

                IPAddress address = IPAddress.None;
                if (cbRemoteIpAddress.IsChecked == true)
                    address = IPAddress.Parse(tbIp.Text);

                if (tbAliveTime.IsEnabled == true) {
                    // Init the server with data from the textboxes WITH setting the aliveTime
                    server = new Rfc1006Server(
                                        new Rfc1006IPEndPoint(address,
                                                Int32.Parse(tbPort.Text),
                                                tbRemoteTSAP.Text,
                                                tbLocalTSAP.Text),
                                        Int32.Parse(tbAliveTime.Text));
                }
                else {
                    // Init the server with data from the textboxes WITHOUT setting the aliveTime
                    server = new Rfc1006Server(
                                        new Rfc1006IPEndPoint(address,
                                                Int32.Parse(tbPort.Text),
                                                tbRemoteTSAP.Text,
                                                tbLocalTSAP.Text));
                }

                server.TransmitTimeout = Int32.Parse(tbTransTimeout.Text);
                server.ReceiveTimeout = Int32.Parse(tbRecTimeout.Text);

                // Start the servers
                server.Start();

                // Show the data window
                TransferWindow dataWindow = new TransferWindow(server);
                this.Visibility = Visibility.Hidden;
                dataWindow.ShowDialog();
            }
            catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
        }

        private void OnExit(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void OnHelp(object sender, RoutedEventArgs e)
        {
            System.Windows.Forms.Help.ShowHelp(null, StartWindow.HelpPath);
        }

        private void OnInfo(object sender, RoutedEventArgs e)
        {
            System.Windows.Forms.Help.ShowHelp(null, StartWindow.InfoPath);
        }
    }
}
