﻿// Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

namespace CS_Server_HelloWorld
{
    using System;
    using System.Text;

    using Rfc1006LibNet.Advanced;
    using Rfc1006LibNet.Advanced.EventArgs;

    /// <summary>
    /// This sample demonstrates a Hello World! application.
    /// </summary>
    /// <remarks>
    /// This application does write/read the 'Hello World!' message via RFC1006
    /// and prints the message on the standard output 
    /// from a server perspective with any RFC1006 client.
    /// </remarks>
    public class Program
    {
        public static void Main(string[] args)
        {
            // Connect to any RFC1006 client 
            // using the specified IP and TSAPs and the default values 
            // for the not defined attributes 
            // like port...
            Console.WriteLine("1) Starting server... \n");
            Rfc1006Server server = new Rfc1006Server("remoteTSAP", "localTSAP");

            // Bind on the status changed event
            server.StatusChanged += server_StatusChanged;
            server.Start();

            // Wait until a client connected.
            Console.WriteLine("###########################################################");
            Console.WriteLine("2) Wait until a client connected... \n");
            server.Connect();
            
            // Transmit a package from a string, 
            // then receive a package as a string.
            Console.WriteLine("###########################################################");
            Console.WriteLine("3) Transmit a package from a string... \n");
            server.Transmit("Hello World!");

            Console.WriteLine("###########################################################");
            Console.WriteLine("4) Receive a package as a string... \n");
            Console.WriteLine(server.ReceiveString());

            // Transmit a package from a byte array, 
            // then receive a package as a byte array.
            Console.WriteLine("###########################################################");
            Console.WriteLine("5) Transmit a package from a byte array... \n");
            server.Transmit(new byte[] { 0x41, 0x42, 0x43 });

            Console.WriteLine("###########################################################");
            Console.WriteLine("6) Receive a package as a byte array... \n");
            Console.WriteLine(Encoding.ASCII.GetString(server.Receive()));

            Console.WriteLine("###########################################################");
            Console.WriteLine("7) Success, server stopping! \n");
            server.Stop();

            Console.WriteLine("###########################################################");
            Console.WriteLine("8) Press key to exit! \n");
            Console.ReadKey();
        }

        private static void server_StatusChanged(object sender, StatusChangedEventArgs e)
        {
            Console.WriteLine("     ->  New Status: " + e.Status);
        }
    }
}
