﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

Imports System.Text

Imports Rfc1006LibNet.Advanced
Imports Rfc1006LibNet.Advanced.EventArgs

Namespace CB_Client_Events

    ''' <summary>
    ''' This sample demonstrates a Hello World! application.
    ''' </summary>
    ''' <remarks>
    ''' This application does write/read the 'Hello World!' message via RFC1006
    ''' and prints the message on the standard output 
    ''' from a client perspective with any RFC1006 client.
    ''' </remarks>
    Public Class Program
        Public Shared Sub Main(args As String())
            ' Connect to any RFC1006 client 
            ' using the specified IP and TSAPs and the default values 
            ' for the not defined attributes 
            ' like port, connection timeout, receive timeout...
            Console.WriteLine("Starting client... " & vbLf)
            Dim client As New Rfc1006Client("127.0.0.1", "localTSAP", "remoteTSAP")

            Console.WriteLine("###########################################################")

            ' Bind on the event before the connection
            AddHandler client.Connecting, AddressOf client_Connecting

            ' Bind on the event after the connection
            AddHandler client.Connected, AddressOf client_Connected

            ' Bind on the event before the disconnection
            AddHandler client.Disconnecting, AddressOf client_Disconnecting

            ' Bind on the event after the disconnection
            AddHandler client.Disconnected, AddressOf client_Disconnected

            ' Bind on the status changed event
            AddHandler client.StatusChanged, AddressOf client_StatusChanged

            ' Bind on the event before the transmit
            AddHandler client.Transmitting, AddressOf client_Transmitting

            ' Bind on the event after the transmit
            AddHandler client.Transmitted, AddressOf client_Transmitted

            ' Instruct the client to do a automatic receive
            client.AutoReceive = True
            AddHandler client.Received, AddressOf client_Received

            client.Start()

            ' Transmits the content of the entered line at the console.
            Dim str As String = String.Empty
            While (InlineAssignHelper(str, Console.ReadLine())) <> "exit" AndAlso str <> "quit"
                client.Transmit(str)
            End While

            Console.WriteLine("###########################################################")
            Console.WriteLine("Client disconnecting! " & vbLf)
            client.[Stop]()

            Console.WriteLine("###########################################################")
            Console.WriteLine("Press key to exit! " & vbLf)
            Console.ReadKey()
        End Sub

        Private Shared Sub client_Received(sender As Object, e As TransferEventArgs)
            Console.WriteLine("Received done! Data= " & Encoding.[Default].GetString(e.Buffer))
        End Sub

        Private Shared Sub client_Transmitted(sender As Object, e As TransferEventArgs)
            Console.WriteLine("Transfer done! Data= " & Encoding.[Default].GetString(e.Buffer))
        End Sub

        Private Shared Sub client_Transmitting(sender As Object, e As TransferEventArgs)
            Console.WriteLine("Doing transfer... (and add ""Hello World"" to the Packet)")

            Dim addToBuffer As String = "Hello World"

            Dim buffer As Byte() = e.Buffer
            Array.Resize(Of [Byte])(buffer, e.Buffer.Length + addToBuffer.Length)
            Array.Copy(Encoding.[Default].GetBytes(addToBuffer), 0, buffer, buffer.Length - addToBuffer.Length, addToBuffer.Length)
            e.Buffer = buffer
        End Sub

        Private Shared Sub client_Disconnected(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Disconnection done!")
        End Sub

        Private Shared Sub client_Disconnecting(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Doing disconnection...")
        End Sub

        Private Shared Sub client_Connected(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Connection done!")
        End Sub

        Private Shared Sub client_Connecting(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Doing connection...")
        End Sub

        Private Shared Sub client_StatusChanged(sender As Object, e As StatusChangedEventArgs)
            Console.WriteLine("     ->  New Status: " & Convert.ToString(e.Status))
        End Sub
        Private Shared Function InlineAssignHelper(Of T)(ByRef target As T, value As T) As T
            target = value
            Return value
        End Function
    End Class
End Namespace