﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

Imports System.Windows
Imports Rfc1006LibNet.Advanced

Imports VB_Client_Graphical.CB_Client_Graphical

Namespace VB_Client_Graphical

    Partial Public Class LoginWindow
        Inherits Window
        Public Shared ReadOnly HelpPath As String = "http://wiki.traeger.de"
        Public Shared ReadOnly InfoPath As String = "http://www.traeger.de"

        Public Sub New()
            InitializeComponent()
        End Sub

        Private Sub btnConnect_Click(sender As Object, e As RoutedEventArgs)
            Try
                Dim client As Rfc1006Client = Nothing

                If tbAliveTime.IsEnabled = False Then
                    client = New Rfc1006Client(Int32.Parse(tbConTimeout.Text), tbIp.Text, Int32.Parse(tbPort.Text), tbRemoteTSAP.Text, tbLocalTSAP.Text)
                Else
                    client = New Rfc1006Client(Int32.Parse(tbConTimeout.Text), tbIp.Text, Int32.Parse(tbPort.Text), tbRemoteTSAP.Text, tbLocalTSAP.Text, Int32.Parse(tbAliveTime.Text))
                End If

                client.TransmitTimeout = Int32.Parse(tbTransTimeout.Text)
                client.ReceiveTimeout = Int32.Parse(tbRecTimeout.Text)

                ' Do the connection to the server
                ' Optional, will be done at the first receiving or transmitting
                client.Start()
                Dim transferWindow As New TransferWindow(client)

                client.AutoReconnect = True

                ' Show the data windows                
                Me.Visibility = Visibility.Hidden
                transferWindow.ShowDialog()
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End Sub

        Private Sub OnExit(sender As Object, e As RoutedEventArgs)
            Me.Close()
        End Sub

        Private Sub OnHelp(sender As Object, e As RoutedEventArgs)
            System.Windows.Forms.Help.ShowHelp(Nothing, LoginWindow.HelpPath)
        End Sub

        Private Sub OnInfo(sender As Object, e As RoutedEventArgs)
            System.Windows.Forms.Help.ShowHelp(Nothing, LoginWindow.InfoPath)
        End Sub
    End Class
End Namespace