﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

Imports System.ComponentModel
Imports System.Net
Imports System.Text
Imports System.Threading
Imports System.Windows
Imports System.Windows.Controls
Imports System.Windows.Documents

Imports Rfc1006LibNet.Advanced
Imports Rfc1006LibNet.Advanced.EventArgs

Imports VB_Client_Graphical.VB_Client_Graphical

Namespace CB_Client_Graphical

    Partial Public Class TransferWindow
        Inherits Window

        Private client As Rfc1006Client

        Public Sub New(client As Rfc1006Client)
            InitializeComponent()

            Me.client = client

            '#Region "Connection Information"

            Me.tbIpAddress.Text = client.EndPoint.Address.ToString()
            Me.tbPort.Text = client.EndPoint.Port.ToString()
            Me.tbLocalTsap.Text = Encoding.[Default].GetString(client.EndPoint.LocalTSAP)
            Me.tbRemoteTsap.Text = Encoding.[Default].GetString(client.EndPoint.RemoteTSAP)

            '#End Region

            '#Region "Configuration Information"

            Me.tbConnectionTimeout.Text = client.ConnectionTimeout.ToString()
            Me.tbReceiveTiemout.Text = client.ReceiveTimeout.ToString()
            Me.tbTransmitTimeout.Text = client.TransmitTimeout.ToString()
            Me.tbAliveTime.Text = If((client.AliveTime >= 0), client.AliveTime.ToString(), String.Empty)

            '#End Region

            '#Region "1. Receive Option (currently not in use)"

            'Me.receiveManuell();

            '#End Region

            '#Region "2. Receive Option (currently in use)"

            ' mount event after a receive was done
            Me.client.AutoReceive = True
            AddHandler Me.client.Received, AddressOf Me.client_Received

            '#End Region

            ' mount event at status changed
            AddHandler Me.client.StatusChanged, AddressOf Me.client_StatusChanged

            lbStatus.Content = Me.client.Status
        End Sub

#Region "1. Receive Option (currently not in use)"

        'Private Sub receiveManuell()
        '    Dim thread As Thread = New Thread(Sub()
        '                                Dim oldStatus As String = String.Empty
        '                                 While True
        '                                Try
        '                                                  Dim ret As String = client.ReceiveString()
        '                                                  Me.Dispatcher.InvokeAsync(New Action(Sub()
        '                                                                                           Me.tbReceived.Text = ret
        '                                                                                    End Sub),
        '                                                                       System.Windows.Threading.DispatcherPriority.DataBind)
        '                                          Catch generatedExceptionName As TimeoutException
        '                                        End Try
        '                                    End While

        '                           End Sub)
        '    Thread.Start()
        'End Sub

#End Region

#Region "2. Receive Option (currently in use)"

        Private Sub client_Received(sender As Object, e As TransferEventArgs)
            Me.Dispatcher.InvokeAsync(New Action(Sub()
                                                     Me.tbReceived.Text = Encoding.[Default].GetString(e.Buffer)
                                                 End Sub), System.Windows.Threading.DispatcherPriority.DataBind)
        End Sub

#End Region

#Region "Transmit"

        Private Sub OnSend(sender As Object, e As RoutedEventArgs)
            Me.send()
        End Sub

        Private Sub OnTbSendTextChanged(sender As Object, e As TextChangedEventArgs)
            If Me.cbAutoSend.IsChecked = True Then
                Me.send()
            End If
        End Sub

        Private Sub send()
            Try
                ' get the text from the textbox
                Dim sendTxt As String = New TextRange(Me.tbSend.Document.ContentStart, Me.tbSend.Document.ContentEnd).Text

                ' send the whole text of the textbox to the stream
                Me.client.Transmit(sendTxt)
            Catch generatedExceptionName As TimeoutException
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End Sub

#End Region

#Region "Status & Configuration"

        Private Sub client_StatusChanged(sender As Object, e As StatusChangedEventArgs)
            Me.Dispatcher.InvokeAsync(New Action(Sub()
                                                     Me.lbStatus.Content = e.Status

                                                     If e.Exception IsNot Nothing AndAlso e.Status = Rfc1006Status.ConnectionClosing Then
                                                         Me.tbErrorMessage.Text = e.Exception.GetType().ToString() & vbLf & vbLf & Convert.ToString(e.Exception.Message)

                                                         If Me.cbAutomaticReconnection.IsChecked = False Then
                                                             Me.ConfigurationInformationIsEnabled(True)
                                                         End If

                                                         Me.tbErrorMessage.Visibility = System.Windows.Visibility.Visible
                                                     ElseIf e.Status = Rfc1006Status.Connected Then
                                                         Me.ConfigurationInformationIsEnabled(False)
                                                         Me.tbErrorMessage.Visibility = System.Windows.Visibility.Hidden
                                                     End If

                                                     Me.cbAutomaticReconnection.IsChecked = client.AutoReconnect
                                                 End Sub), System.Windows.Threading.DispatcherPriority.Send)
        End Sub

        Private Sub ConfigurationInformationIsEnabled(value As Boolean)
            If Me.cbAutomaticReconnection.IsChecked = False Then
                Me.btConnect.IsEnabled = value
            Else
                Me.btConnect.IsEnabled = False
            End If

            Me.btDisconnect.IsEnabled = Not value

            Me.tbSend.IsEnabled = Not value
            Me.btSend.IsEnabled = Not value
            Me.cbAutoSend.IsEnabled = Not value

            Me.tbIpAddress.IsEnabled = value
            Me.tbPort.IsEnabled = value
            Me.tbLocalTsap.IsEnabled = value
            Me.tbRemoteTsap.IsEnabled = value
            Me.tbConnectionTimeout.IsEnabled = value
            Me.tbAliveTime.IsEnabled = value
        End Sub

        Private Sub OnWindowClosing(sender As Object, e As CancelEventArgs)
            Me.client.Stop()
            ' optional, will be done at disposing if not done by user  
            Environment.Exit(0)
        End Sub

        Private Sub OnConfigurationChanged(sender As Object, e As RoutedEventArgs)
            '#Region "Connection Information"

            Me.client.AutoReconnect = CBool(Me.cbAutomaticReconnection.IsChecked)

            Me.client.EndPoint.Address = IPAddress.Parse(Me.tbIpAddress.Text)
            Me.client.EndPoint.Port = Int32.Parse(Me.tbPort.Text)
            Me.client.EndPoint.LocalTSAP = Encoding.[Default].GetBytes(Me.tbLocalTsap.Text)
            Me.client.EndPoint.RemoteTSAP = Encoding.[Default].GetBytes(Me.tbRemoteTsap.Text)

            '#End Region

            '#Region "Configuration Information"

            Me.client.ConnectionTimeout = Int32.Parse(Me.tbConnectionTimeout.Text)
            Me.client.ReceiveTimeout = Int32.Parse(Me.tbReceiveTiemout.Text)
            Me.client.TransmitTimeout = Int32.Parse(Me.tbTransmitTimeout.Text)
            Me.client.AliveTime = If((Me.tbAliveTime.Text <> [String].Empty), Int32.Parse(Me.tbAliveTime.Text), -1)

            '#End Region
        End Sub

        Private Sub OnConnect(sender As Object, e As RoutedEventArgs)
            Me.ConfigurationInformationIsEnabled(False)
            Me.client.Start()
        End Sub

        Private Sub OnDisconnect(sender As Object, e As RoutedEventArgs)
            Me.cbAutomaticReconnection.IsChecked = False
            Me.ConfigurationInformationIsEnabled(True)
            Me.client.Stop()
        End Sub

#End Region

        Private Sub OnHelp(sender As Object, e As RoutedEventArgs)
            System.Windows.Forms.Help.ShowHelp(Nothing, LoginWindow.HelpPath)
        End Sub

        Private Sub OnInfo(sender As Object, e As RoutedEventArgs)
            System.Windows.Forms.Help.ShowHelp(Nothing, LoginWindow.InfoPath)
        End Sub

        Private Sub OnExit(sender As Object, e As RoutedEventArgs)
            ' optional, will be done at disposing if not done by user  
            Me.client.Stop()
            Environment.Exit(0)
        End Sub

        Private Sub OnCleanSend(sender As Object, e As RoutedEventArgs)
            Me.tbSend.Document.Blocks.Clear()
        End Sub

        Private Sub OnCleanReceive(sender As Object, e As RoutedEventArgs)
            Me.tbReceived.Text = String.Empty
        End Sub
    End Class
End Namespace