﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.
Imports System.Text
Imports System.Threading

Imports Rfc1006LibNet.Advanced

Namespace CB_Client_SimpleEchoTransmit

    ''' <summary>
    ''' This sample demonstrates a Hello World! application.
    ''' </summary>
    ''' <remarks>
    ''' This application does write/read the 'Hello World!' message via RFC1006
    ''' and prints the message on the standard output 
    ''' from a client perspective with any RFC1006 client.
    ''' </remarks>
    Public Class Program
        Public Shared Sub Main(args As String())
            ' Connect to any RFC1006 client 
            ' using the specified IP and TSAPs and the default values 
            ' for the not defined attributes 
            ' like port, connection timeout, receive timeout...
            Console.WriteLine("1) Starting client... " & vbLf)
            Dim client As New Rfc1006Client("127.0.0.1", "localTSAP", "remoteTSAP")
            client.Connect()

            While True
                Try
                    ' Receive a package and transmit the same buffer back to the server.
                    Console.WriteLine("###########################################################")
                    Console.WriteLine("2) Receiving... " & vbLf)
                    Dim ret As String = client.ReceiveString()
                    Console.WriteLine("Received: " & ret)

                    Console.WriteLine("###########################################################")
                    Console.WriteLine("3) Transmitting... " & vbLf)
                    client.Transmit(ret)
                Catch generatedExceptionName As TimeoutException
                    Console.WriteLine("Server did not transmit a package in " + client.ReceiveTimeout & " milliseconds.")
                End Try
            End While
        End Sub
    End Class
End Namespace