﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

Imports System.Collections.Generic
Imports System.Linq
Imports System.Net
Imports System.Text
Imports System.Windows
Imports System.Windows.Controls
Imports System.Windows.Data
Imports System.Windows.Documents
Imports System.Windows.Input
Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports System.Windows.Navigation
Imports System.Windows.Shapes

Imports Rfc1006LibNet.Advanced

Namespace VB_Server_Graphical

    Partial Public Class StartWindow
        Inherits Window
        Public Shared ReadOnly HelpPath As String = "http://www.wiki.traeger.de"
        Public Shared ReadOnly InfoPath As String = "http://www.traeger.de"

        Public Sub New()
            InitializeComponent()
        End Sub

        Private Sub btnStart_Click(sender As Object, e As RoutedEventArgs)
            Try
                Dim server As Rfc1006Server = Nothing

                Dim address As IPAddress = IPAddress.None
                If cbRemoteIpAddress.IsChecked = True Then
                    address = IPAddress.Parse(tbIp.Text)
                End If

                If tbAliveTime.IsEnabled = True Then
                    ' Init the server with data from the textboxes WITH setting the aliveTime
                    server = New Rfc1006Server(New Rfc1006IPEndPoint(address, Int32.Parse(tbPort.Text), tbRemoteTSAP.Text, tbLocalTSAP.Text), Int32.Parse(tbAliveTime.Text))
                Else
                    ' Init the server with data from the textboxes WITHOUT setting the aliveTime
                    server = New Rfc1006Server(New Rfc1006IPEndPoint(address, Int32.Parse(tbPort.Text), tbRemoteTSAP.Text, tbLocalTSAP.Text))
                End If

                server.TransmitTimeout = Int32.Parse(tbTransTimeout.Text)
                server.ReceiveTimeout = Int32.Parse(tbRecTimeout.Text)

                ' Start the servers
                server.Start()

                ' Show the data window
                Dim dataWindow As New TransferWindow(server)
                Me.Visibility = Visibility.Hidden
                dataWindow.ShowDialog()
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End Sub

        Private Sub OnExit(sender As Object, e As RoutedEventArgs)
            Me.Close()
        End Sub

        Private Sub OnHelp(sender As Object, e As RoutedEventArgs)
            System.Windows.Forms.Help.ShowHelp(Nothing, StartWindow.HelpPath)
        End Sub

        Private Sub OnInfo(sender As Object, e As RoutedEventArgs)
            System.Windows.Forms.Help.ShowHelp(Nothing, StartWindow.InfoPath)
        End Sub
    End Class
End Namespace