﻿// Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

namespace CS_Client_HelloWorld
{
    using System;
    using System.Text;

    using Rfc1006LibNet.Advanced;
    using Rfc1006LibNet.Advanced.EventArgs;

    /// <summary>
    /// This sample demonstrates a Hello World! application.
    /// </summary>
    /// <remarks>
    /// This application does write/read the 'Hello World!' message via RFC1006
    /// and prints the message on the standard output 
    /// from a client perspective with any RFC1006 client.
    /// </remarks>
    public class Program
    {
        public static void Main(string[] args)
        {
            // Connect to any RFC1006 client 
            // using the specified IP and TSAPs and the default values 
            // for the not defined attributes 
            // like port, connection timeout, receive timeout...
            Console.WriteLine("1) Starting client... \n");
            Rfc1006Client client = new Rfc1006Client("127.0.0.1", "localTSAP", "remoteTSAP");

            // Bind on the status changed event
            client.StatusChanged += client_StatusChanged;

            client.Connect();

            // Sets the receive timeout to 5 seconds (default if not set).
            client.ReceiveTimeout = 5000;

            // Sets the transmit timeout to 5 seconds (default if not set).
            client.TransmitTimeout = 5000;

            // Receive a package from a string, 
            // then transmit a package as a string.
            Console.WriteLine("###########################################################");
            Console.WriteLine("3) Receive a package as a string... \n");
            Console.WriteLine(client.ReceiveString());

            Console.WriteLine("###########################################################");
            Console.WriteLine("4) Transmit a package from a string... \n");
            client.Transmit("Hello World!");

            // Receive a package from a byte array, 
            // then transmit a package as a byte array.
            Console.WriteLine("###########################################################");
            Console.WriteLine("5) Transmit a package from a byte array... \n");
            client.Transmit(new byte[] { 0x41, 0x42, 0x43 });

            Console.WriteLine("###########################################################");
            Console.WriteLine("6) Receive a package as a byte array... \n");
            Console.WriteLine(Encoding.ASCII.GetString(client.Receive()));

            Console.WriteLine("###########################################################");
            Console.WriteLine("7) Success, client disconnecting! \n");
            client.Stop();

            Console.WriteLine("###########################################################");
            Console.WriteLine("8) Press key to exit! \n");
            Console.ReadKey();
        }

        private static void client_StatusChanged(object sender, StatusChangedEventArgs e)
        {
            Console.WriteLine("     ->  New Status: " + e.Status);
        }
    }
}
