﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

Imports System.Text

Imports Rfc1006LibNet.Advanced
Imports Rfc1006LibNet.Advanced.EventArgs

Namespace VB_server_Events

    ''' <summary>
    ''' This sample demonstrates a Hello World! application.
    ''' </summary>
    ''' <remarks>
    ''' This application does write/read the 'Hello World!' message via RFC1006
    ''' and prints the message on the standard output 
    ''' from a server perspective with any RFC1006 server.
    ''' </remarks>
    Public Class Program
        Public Shared Sub Main(args As String())
            ' Connect to any RFC1006 server 
            ' using the specified IP and TSAPs and the default values 
            ' for the not defined attributes 
            ' like port...
            Console.WriteLine("Starting server... " & vbLf)
            Dim server As New Rfc1006Server("a", "b")

            ' Bind on the event after the connection
            AddHandler server.Connected, AddressOf server_Connected

            ' Bind on the event before the start of the server
            AddHandler server.Starting, AddressOf server_Starting

            ' Bind on the event after the start of the server
            AddHandler server.Started, AddressOf server_Started

            ' Bind on the event before the stop of the server
            AddHandler server.Stopping, AddressOf server_Stopping

            ' Bind on the event after the stop of the server
            AddHandler server.Stopped, AddressOf server_Stopped

            ' Bind on the status changed event
            AddHandler server.StatusChanged, AddressOf server_StatusChanged

            ' Bind on the event before the transmit
            AddHandler server.Transmitting, AddressOf server_Transmitting

            ' Bind on the event after the transmit
            AddHandler server.Transmitted, AddressOf server_Transmitted

            ' Instruct the server to do a automatic receive
            server.AutoReceive = True
            AddHandler server.Received, AddressOf server_Received

            server.Start()

            ' Wait until a client connected.
            Console.WriteLine("###########################################################")
            Console.WriteLine("Wait until a client connected... " & vbLf)
            server.Connect()

            Console.WriteLine("###########################################################")

            ' Transmits the content of the entered line at the console.
            Dim str As String = String.Empty
            While (InlineAssignHelper(str, Console.ReadLine())) <> "exit" AndAlso str <> "quit"
                server.Transmit(str)
            End While

            Console.WriteLine("###########################################################")
            Console.WriteLine("Success, server stopping! " & vbLf)
            server.[Stop]()

            Console.WriteLine("###########################################################")
            Console.WriteLine("Press key to exit! " & vbLf)
            Console.ReadKey()
        End Sub

        Private Shared Sub server_Stopped(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Server stopped!")
        End Sub

        Private Shared Sub server_Stopping(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Server stopping..")
        End Sub

        Private Shared Sub server_Started(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Server started!")
        End Sub

        Private Shared Sub server_Starting(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Server starting..")
        End Sub

        Private Shared Sub server_Received(sender As Object, e As TransferEventArgs)
            Console.WriteLine("Received done! Data= " & Encoding.[Default].GetString(e.Buffer))
        End Sub

        Private Shared Sub server_Transmitted(sender As Object, e As TransferEventArgs)
            Console.WriteLine("Transfer done! Data= " & Encoding.[Default].GetString(e.Buffer))
        End Sub

        Private Shared Sub server_Transmitting(sender As Object, e As TransferEventArgs)
            Console.WriteLine("Doing transfer... (and add ""Hello World"" to the Packet)")

            Dim addToBuffer As String = "Hello World"

            Dim buffer As Byte() = e.Buffer
            Array.Resize(Of [Byte])(buffer, e.Buffer.Length + addToBuffer.Length)
            Array.Copy(Encoding.[Default].GetBytes(addToBuffer), 0, buffer, buffer.Length - addToBuffer.Length, addToBuffer.Length)
            e.Buffer = buffer
        End Sub

        Private Shared Sub server_Connected(sender As Object, e As ConnectionEventArgs)
            Console.WriteLine("Connection done!")
        End Sub

        Private Shared Sub server_StatusChanged(sender As Object, e As StatusChangedEventArgs)
            Console.WriteLine("     ->  New Status: " & Convert.ToString(e.Status))
        End Sub
        Private Shared Function InlineAssignHelper(Of T)(ByRef target As T, value As T) As T
            target = value
            Return value
        End Function
    End Class
End Namespace