﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

Imports System.Text

Imports Rfc1006LibNet.Advanced
Imports Rfc1006LibNet.Advanced.EventArgs

Namespace VB_Server_HelloWorld

    ''' <summary>
    ''' This sample demonstrates a Hello World! application.
    ''' </summary>
    ''' <remarks>
    ''' This application does write/read the 'Hello World!' message via RFC1006
    ''' and prints the message on the standard output 
    ''' from a server perspective with any RFC1006 client.
    ''' </remarks>
    Public Class Program
        Public Shared Sub Main(args As String())
            ' Connect to any RFC1006 client 
            ' using the specified IP and TSAPs and the default values 
            ' for the not defined attributes 
            ' like port...
            Console.WriteLine("1) Starting server... " & vbLf)
            Dim server As New Rfc1006Server("remoteTSAP", "localTSAP")

            ' Bind on the status changed event
            AddHandler server.StatusChanged, AddressOf server_StatusChanged
            server.Start()

            ' Wait until a client connected.
            Console.WriteLine("###########################################################")
            Console.WriteLine("2) Wait until a client connected... " & vbLf)
            server.Connect()

            ' Transmit a package from a string, 
            ' then receive a package as a string.
            Console.WriteLine("###########################################################")
            Console.WriteLine("3) Transmit a package from a string... " & vbLf)
            server.Transmit("Hello World!")

            Console.WriteLine("###########################################################")
            Console.WriteLine("4) Receive a package as a string... " & vbLf)
            Console.WriteLine(server.ReceiveString())

            ' Transmit a package from a byte array, 
            ' then receive a package as a byte array.
            Console.WriteLine("###########################################################")
            Console.WriteLine("5) Transmit a package from a byte array... " & vbLf)
            server.Transmit(New Byte() {&H41, &H42, &H43})

            Console.WriteLine("###########################################################")
            Console.WriteLine("6) Receive a package as a byte array... " & vbLf)
            Console.WriteLine(Encoding.ASCII.GetString(server.Receive()))

            Console.WriteLine("###########################################################")
            Console.WriteLine("7) Success, server stopping! " & vbLf)
            server.[Stop]()

            Console.WriteLine("###########################################################")
            Console.WriteLine("8) Press key to exit! " & vbLf)
            Console.ReadKey()
        End Sub

        Private Shared Sub server_StatusChanged(sender As Object, e As StatusChangedEventArgs)
            Console.WriteLine("     ->  New Status: " & Convert.ToString(e.Status))
        End Sub
    End Class
End Namespace