﻿// Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

namespace CS_Client_Graphical
{
    using System;
    using System.Windows;

    using Rfc1006LibNet.Advanced;

    public partial class LoginWindow : Window
    {
        public static readonly string HelpPath = "http://wiki.traeger.de";
        public static readonly string InfoPath = "http://www.traeger.de";

        public LoginWindow()
        {
            InitializeComponent();
        }

        private void btnConnect_Click(object sender, RoutedEventArgs e)
        {
            try {
                Rfc1006Client client = null;

                if (tbAliveTime.IsEnabled == false) {
                    client = new Rfc1006Client(
                                            Int32.Parse(tbConTimeout.Text),
                                            tbIp.Text,
                                            Int32.Parse(tbPort.Text),
                                            tbRemoteTSAP.Text,
                                            tbLocalTSAP.Text);
                }
                else {
                    client = new Rfc1006Client(
                                            Int32.Parse(tbConTimeout.Text),
                                            tbIp.Text,
                                            Int32.Parse(tbPort.Text),
                                            tbRemoteTSAP.Text,
                                            tbLocalTSAP.Text,
                                            Int32.Parse(tbAliveTime.Text));
                }

                client.TransmitTimeout = Int32.Parse(tbTransTimeout.Text);
                client.ReceiveTimeout = Int32.Parse(tbRecTimeout.Text);

                // Do the connection to the server
                client.Start(); // Optional, will be done at the first receiving or transmitting
                TransferWindow transferWindow = new TransferWindow(client);

                client.AutoReconnect = true;

                // Show the data windows                
                this.Visibility = Visibility.Hidden;
                transferWindow.ShowDialog();
            }
            catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
        }

        private void OnExit(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void OnHelp(object sender, RoutedEventArgs e)
        {
            System.Windows.Forms.Help.ShowHelp(null, LoginWindow.HelpPath);
        }

        private void OnInfo(object sender, RoutedEventArgs e)
        {
            System.Windows.Forms.Help.ShowHelp(null, LoginWindow.InfoPath);
        }
    }
}
