﻿// Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

namespace CS_Server_SimpleEchoTransmit
{
    using System;
    using Rfc1006LibNet.Advanced;

    /// <summary>
    /// This sample demonstrates a Hello World! application.
    /// </summary>
    /// <remarks>
    /// This application does write/read the 'Hello World!' message via RFC1006
    /// and prints the message on the standard output 
    /// from a server perspective with any RFC1006 client.
    /// </remarks>
    public class Program
    {
        public static void Main(string[] args)
        {
            // Connect to any RFC1006 client 
            // using the specified IP and TSAPs and the default values 
            // for the not defined attributes 
            // like port...
            Console.WriteLine("1) Starting server... \n");
            Rfc1006Server server = new Rfc1006Server("remoteTSAP", "localTSAP");
            server.Start();

            // Wait until a client connected.
            Console.WriteLine("###########################################################");
            Console.WriteLine("2) Wait until a client connected... \n");
            server.Connect();
            server.Connect();
            while (true)
            {
                try
                {
                    // Receive a package and transmit the same buffer back to the server.
                    Console.WriteLine("###########################################################");
                    Console.WriteLine("3) Receiving... \n");
                    string ret = server.ReceiveString();
                    Console.WriteLine("Received: " + ret);

                    Console.WriteLine("###########################################################");
                    Console.WriteLine("4) Transmitting... \n");
                    server.Transmit(ret);
                }
                catch (TimeoutException)
                {
                    Console.WriteLine("Client did not transmit a package in " + server.ReceiveTimeout + " milliseconds.");
                }
            }
        }
    }
}
