﻿' Copyright (c) Traeger Industry Components GmbH.  All Rights Reserved.

Imports System.Text
Imports Rfc1006LibNet.Advanced

Namespace CS_Server_SimpleEchoTransmit

    ''' <summary>
    ''' This sample demonstrates a Hello World! application.
    ''' </summary>
    ''' <remarks>
    ''' This application does write/read the 'Hello World!' message via RFC1006
    ''' and prints the message on the standard output 
    ''' from a server perspective with any RFC1006 client.
    ''' </remarks>
    Public Class Program
        Public Shared Sub Main(args As String())
            ' Connect to any RFC1006 client 
            ' using the specified IP and TSAPs and the default values 
            ' for the not defined attributes 
            ' like port...
            Console.WriteLine("1) Starting server... " & vbLf)
            Dim server As New Rfc1006Server("remoteTSAP", "localTSAP")
            server.Start()

            ' Wait until a client connected.
            Console.WriteLine("###########################################################")
            Console.WriteLine("2) Wait until a client connected... " & vbLf)
            server.Connect()
            server.Connect()
            While True
                Try
                    ' Receive a package and transmit the same buffer back to the server.
                    Console.WriteLine("###########################################################")
                    Console.WriteLine("3) Receiving... " & vbLf)
                    Dim ret As String = server.ReceiveString()
                    Console.WriteLine("Received: " & ret)

                    Console.WriteLine("###########################################################")
                    Console.WriteLine("4) Transmitting... " & vbLf)
                    server.Transmit(ret)
                Catch generatedExceptionName As TimeoutException
                    Console.WriteLine("Client did not transmit a package in " + server.ReceiveTimeout & " milliseconds.")
                End Try
            End While
        End Sub
    End Class
End Namespace